$(document).ready(function () {

  $(document).on('change', "#access-key", function () {
    if ($(`#${$(this).attr("id")} :selected`).val()) {
      let url = $(`#${$(this).attr("id")} :selected`).data("access-key-by-id-url");

      $.ajax({
        type: "GET",
        url: url,
        contentType: false,
        processData: false,
        dataType: "json",
        beforeSend: function () {
          $(".modal-spinner").fadeIn();
          $('.modal-container').fadeOut();
        },
        success: function (response) {
          $("#access-key-confirm").show();
          $("#access-key-url").text(response.data.accessKey);

        }
      });
    }
  });

  $(document).on('change', "#resource-type", function () {
    if ($(`#${$(this).attr("id")} :selected`).val()) {
      let url = $(`#${$(this).attr("id")} :selected`).data("resource-types-url");
      let resourceType = $(`#${$(this).attr("id")} :selected`).text();
      let generateUrl = $(`#${$(this).attr("id")} :selected`).data("generate-url");

      $.ajax({
        type: "GET",
        url: url,
        contentType: false,
        processData: false,
        dataType: "json",
        beforeSend: function () {
          $(".modal-spinner").fadeIn();
          $('.modal-container').fadeOut();
        },
        success: function (response) {
          updateSelectBox("resources", response.data.resources, true, generateUrl, resourceType, "Please Select Resource");
          $(".modal-spinner").fadeOut();
          $('.modal-container').fadeIn();

        }
      });
    }
  });


  $(document).on('change', "#resources", function () {
    if ($(`#${$(this).attr("id")} :selected`).val()) {
      let resourceType = $(`#resource-type :selected`);
      let resourceId = $(`#${$(this).attr("id")} :selected`).val();
      let url = resourceType.data("generate-url") + "/" + resourceId;

      $.ajax({
        type: "GET",
        url: url,
        contentType: false,
        processData: false,
        dataType: "json",
        beforeSend: function () {
          $(".modal-spinner").fadeIn();
          $('.modal-container').fadeOut();
        },
        success: function (response) {
          if (response.url) {
            $("#resource-url").val(response.url);
          }
        }
      });
    }
  });


  $(document).on("click", "#copy-access-key", function (e) {
    e.preventDefault();

    let keyElement = document.getElementById("access-key-url");

    if (!keyElement || !keyElement.textContent.trim()) {
      alert("No key to copy!");
      return;
    }

    let range = document.createRange();
    range.selectNodeContents(keyElement);

    let selection = window.getSelection();
    selection.removeAllRanges();
    selection.addRange(range);

    $("#copy-icon").removeClass("fa-copy").addClass("fa-check");

    try {
      document.execCommand("copy");
      selection.removeAllRanges();

      setTimeout(function () {
        $("#copy-icon").removeClass("fa-check").addClass("fa-copy");
      }, 2000);

    } catch (err) {
      console.error("Copy failed", err);
      alert("Unable to copy. Please copy manually.");
    }

  });


  $(document).on("click", "#copy-resource-url", function (e) {
    e.preventDefault();

    let keyElement = document.getElementById("resource-url");

    if (!keyElement || !keyElement.value.trim()) {
      alert("No key to copy!");
      return;
    }

    keyElement.select();
    keyElement.setSelectionRange(0, 99999);

    function showCopiedEffect() {
      $("#copy-resource-url-icon").removeClass("fa-copy").addClass("fa-check");

      setTimeout(function () {
        $("#copy-resource-url-icon").removeClass("fa-check").addClass("fa-copy");
      }, 2000);
    }

    if (navigator.clipboard && navigator.clipboard.writeText) {
      navigator.clipboard.writeText(keyElement.value)
        .then(showCopiedEffect)
        .catch(function (err) {
          console.warn("Clipboard API failed, falling back", err);
          try {
            document.execCommand("copy");
            showCopiedEffect();
          } catch (err) {
            console.error("Copy failed", err);
            alert("Unable to copy. Please copy manually.");
          }
        });
    } else {
      try {
        document.execCommand("copy");
        showCopiedEffect();
      } catch (err) {
        console.error("Copy failed", err);
        alert("Unable to copy. Please copy manually.");
      }
    }
  });

  $(document).on("click", "#copy-embed-token-api-url", function (e) {
    e.preventDefault();

    let keyElement = document.getElementById("embed-token-api-url");

    if (!keyElement || !keyElement.value.trim()) {
      alert("No key to copy!");
      return;
    }

    keyElement.select();
    keyElement.setSelectionRange(0, 99999);

    function showCopiedEffect() {
      $("#copy-embed-token-api-url-icon").removeClass("fa-copy").addClass("fa-check");

      setTimeout(function () {
        $("#copy-embed-token-api-url-icon").removeClass("fa-check").addClass("fa-copy");
      }, 2000);
    }

    if (navigator.clipboard && navigator.clipboard.writeText) {
      navigator.clipboard.writeText(keyElement.value)
        .then(showCopiedEffect)
        .catch(function (err) {
          console.warn("Clipboard API failed, falling back", err);
          try {
            document.execCommand("copy");
            showCopiedEffect();
          } catch (err) {
            console.error("Copy failed", err);
            alert("Unable to copy. Please copy manually.");
          }
        });
    } else {
      try {
        document.execCommand("copy");
        showCopiedEffect();
      } catch (err) {
        console.error("Copy failed", err);
        alert("Unable to copy. Please copy manually.");
      }
    }
  });



  function updateSelectBox(id, data, placeholder, accessUrl, resourceType, placeholderSentence = null) {
    $(`select[id="${id}"]`).empty();

    $(`select[id="${id}"]`).append(
      `<option value="">${placeholderSentence}</option>`
    );

    $.each(data, function (key, value) {
      let name = value.clean_name || value.name || value.label;
      $(`select[id="${id}"]`).append(
        '<option value="' + value.id + '" data-access-url="' + accessUrl + '">' + name + "</option>"
      );
    });
  }


});