$(document).ready(function () {

    $(document).on('change', "#access-type", function () {
        if ($('#access-type :selected').val() == "public") {
            $("#confirm-public-dashboard-modal").modal({
                keyboard: false,
                backdrop: 'static',
                show: true
            });

        }
    });

    $(document).on('show.bs.modal','#confirm-public-dashboard-modal', function () {
        $(this).addClass('modal-front');
        $('.modal-backdrop').last().addClass('backdrop-front');
    });

    $(document).on('hide.bs.modal', '#confirm-public-dashboard-modal',function () {
        $(this).removeClass('modal-front');
        $('.modal-backdrop').removeClass('backdrop-front');
    });

    $("#saveBtn-confirm-public-dashboard").on('click', function () {
        $("#confirm-public-dashboard-modal").modal("hide");
    });

    $("#cancelBtn-confirm-public-dashboard").on('click', function () {
        $('#access-type').val('private');
        $("#confirm-public-pivot-table-modal").modal("hide");
    });

    $(document).on("click", "#add-dashboard-button", function (e) {


        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            success: function (response) {
                $('#add-dashboard-modal-container').html(response);
                $('#add-dashboard-modal').modal('show');

                // demo mode enabled
                if ($(".demo-alert").length > 0) {
                    $("input[name=dashboard_name]").on("keydown", function (e) {
                        e.preventDefault();
                        alertify.error("Available only in full version");
                        return false;
                    });

                    $("input[name=dashboard_title]").on("keydown", function (e) {
                        e.preventDefault();
                        alertify.error("Available only in full version");
                        return false;
                    });


                    let dashboardIcon = $("select[name=dashboard_icon]").val();
                    $("select[name=dashboard_icon]").on("change", function (e) {

                        $(this).val(dashboardIcon);

                        alertify.error("Available only in full version");
                        return false;
                    });

                    $("#add-dashboard-form").on("click", "#saveBtn-add-dashboard", function () {

                        $("#add-dashboard-modal").modal('hide');
                    });



                } else {

                    $("#add-dashboard-form").on("click", "#saveBtn-add-dashboard", function () {

                        let fields = ["dashboard_name", "dashboard_icon", "dashboard_title"];
                        sendAjaxRequest("add-dashboard-form", fields, "add-dashboard-confirm", "add-dashboard-error", reloadDashboardsTable, ["dashboards"]);
                        reloadForm("dashboard-aside-container");

                    });

                }



            },
        });



    })


    $('#add-dashboard-modal').on('hidden.bs.modal', function () {
        reloadForm("add-dashboard-form");
    });



    $("#add-dashboard-form").on("click", "#saveBtn-add-dashboard", function () {

        let fields = ["dashboard_name", "dashboard_icon", "dashboard_title"];
        sendAjaxRequest("add-dashboard-form", fields, "add-dashboard-confirm", "add-dashboard-error", reloadDashboardsTable, ["dashboards"]);
        reloadForm("dashboard-aside-container");

    });

    $(document).on('click', ".move-up-dashboard", function (event) {
        event.preventDefault();
        let url = $(this).data("url");
        $.ajax({
            type: "PATCH",
            url: url,
            contentType: false,
            processData: false,
            dataType: "json",
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            success: function (response) {
                reloadDashboardsTable("dashboards")
                reloadForm("dashboard-aside-container")
                if (response.message) {

                    $(`#success-modal`).find('h5').text(response.message).show();
                    $(`#success-modal`).modal('show');
                }

                if (response.demo) {
                    $(`#demo-modal`).find('h5').text(response.demo).show();
                    $(`#demo-modal`).modal('show');
                }


            }, error: function (response) {
                if (response.responseJSON) {
                    $(`#success-modal`).find('h5').text(response.responseJSON.message).show();
                    $(`#success-modal`).modal('show');
                }
            }
        });

    });


    $(document).on('click', ".move-down-dashboard", function (event) {
        event.preventDefault();
        let url = $(this).data("url");
        $.ajax({
            type: "PATCH",
            url: url,
            contentType: false,
            processData: false,
            dataType: "json",
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            success: function (response) {
                reloadDashboardsTable("dashboards");
                reloadForm("dashboard-aside-container");

                if (response.message) {

                    $(`#success-modal`).find('h5').text(response.message).show();
                    $(`#success-modal`).modal('show');
                }

                if (response.demo) {
                    $(`#demo-modal`).find('h5').text(response.demo).show();
                    $(`#demo-modal`).modal('show');
                }


            }, error: function (response) {
                if (response.responseJSON) {

                    $(`#success-modal`).find('h5').text(response.responseJSON.message).show();
                    $(`#success-modal`).modal('show');
                }
            }
        });

    });


    $(document).on('click', ".edit-dashboard", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            success: function (response) {
                $('#edit-dashboard-modal-container').html(response);
                $('#edit-dashboard-modal').modal('show');

                // demo mode enabled
                if ($(".demo-alert").length > 0) {


                    $("input[name=dashboard_name]").on("keydown", function (e) {
                        e.preventDefault();
                        alertify.error("Available only in full version");
                        return false;
                    });

                    $("input[name=dashboard_title]").on("keydown", function (e) {
                        e.preventDefault();
                        alertify.error("Available only in full version");
                        return false;
                    });


                    let dashboardIcon = $("select[name=dashboard_icon]").val();
                    $("select[name=dashboard_icon]").on("change", function (e) {

                        $(this).val(dashboardIcon);

                        alertify.error("Available only in full version");
                        return false;
                    });


                }



                $("#edit-dashboard-form").on("click", "#saveBtn-edit-dashboard", function () {
                    if ($(".demo-alert").length > 0) {
                        $("#edit-dashboard-modal").modal('hide');
                        return;
                    }

                    let fields = ["first_name", "last_name", "user_name", "role", "Email", "group", "Phone", "status", "email_confirm"];
                    sendAjaxRequest("edit-dashboard-form", fields, "edit-dashboard-confirm", "edit-dashboard-error", function () {
                        reloadDashboardsTable("dashboards");
                        reloadForm("dashboard-aside-container");
                    }, []);
                });

                $("#edit-dashboard-form").on("click", "#cancelBtn-edit-dashboard", function () {
                    reloadForm("edit-dashboard-form");
                });


            },
        });

    });



    // delete dashboard modal
    $(document).on('click', ".delete-dashboard", function (event) {
        let widget = $(this).closest('.card-header').find('h3').text();
        $('#delete-dashboard-modal').find('.modal-body p').text(`Are you sure you want to delete this dashboard?`)
        $('#delete-dashboard-form').attr('data-url', $(this).attr('data-url'));
    });

    $("#delete-dashboard-form").on("click", "#saveBtn-delete-dashboard", function () {
        sendAjaxRequestWithSuccess("delete-dashboard-form", 'delete-dashboard-modal', function () {
            reloadDashboardsTable("dashboards");
            reloadForm("dashboard-aside-container");
        }, []);

    });





});
