$(document).ready(function () {

    window.applyuserSearch = function applyuserSearch(usersTable) {
        $('.search-filter').click(function () {
            usersTable.column(0).search($('#userName-search').val());
            usersTable.column(1).search($('#fullname-search').val());
            usersTable.column(2).search($('#email-search').val());
            usersTable.column(3).search($('#group-search').val());
            usersTable.column(4).search($('#status-search').val());
            usersTable.column(5).search($('#emailConfirmation-search').val());
            usersTable.draw();

        });


    }

    window.clearuserSearch = function clearuserSearch(usersTable) {
        $('#users-pane').on('click', '.reset-filter', function () {
            $('#userName-search').val("");
            $('#fullname-search').val("");
            $('#email-search').val("");
            $('#group-search option:first').prop('selected', true);
            $('#status-search option:first').prop('selected', true);
            $('#emailConfirmation-search option:first').prop('selected', true);

            usersTable.columns().search("").draw();
        });

    }


    window.clearGroupsSearch = function clearGroupsSearch(groupsTable) {
        $('#groups-pane').on('click', '.reset-filter', function () {
            $('#search-groups').val("");
            groupsTable.search("").draw();
        });
    }

    window.clearCategoriesSearch = function clearCategoriesSearch(categoriesTable) {
        $('.container').on('click', '.reset-filter', function () {
            $('#search-categories').val("");
            categoriesTable.search("").draw();
        });
    }


    window.sendAjaxRequest = function sendAjaxRequest(formId, fields, successElementID, errorElementID, callback, callbackParams, appendResponse = false) {

        var form = document.getElementById(formId);
        let url = $(`#${formId}`).attr('data-url');
        $.ajax({
            type: "POST",
            url: url,
            data: new FormData(form),
            contentType: false,
            processData: false,
            dataType: "json",
            success: function (response) {
                if (response.message) {

                    $(`#${successElementID}`).text(response.message).show();
                    $(`#${errorElementID}`).hide();
                    if (callback && appendResponse) {
                        callback(...callbackParams, response);
                    }
                    else if (callback) {
                        callback(...callbackParams);
                    }
                }

                if (response.demo) {
                    $(`#demo-modal`).find('h5').text(response.demo).show();
                    $(`#demo-modal`).modal('show');
                }
            },
            error: function (response) {
                response = response.responseJSON;

                if (response.message) {
                    $(`#${errorElementID}`).text(response.message).show();
                    $(`#${successElementID}`).hide();
                }
                if (response.errors) {
                    fields.every(error => {
                        if (response.errors[error]) {

                            $(`#${errorElementID}`).text(response.errors[error][0]).show();

                            $(`#${successElementID}`).hide();

                            return false;
                        }
                        return true;

                    });

                }

                $(`#${successElementID}`).hide();
            }
        });

    }

    window.sendAjaxRequestAccessKeys = function sendAjaxRequestAccessKeys(formId, fields, successElementID, errorElementID, callback, callbackParams, appendResponse = false) {

        var form = document.getElementById(formId);
        let url = $(`#${formId}`).attr('data-url');
        $.ajax({
            type: "POST",
            url: url,
            data: new FormData(form),
            contentType: false,
            processData: false,
            dataType: "json",
            success: function (response) {
                if (response.message) {

                    $(`#${successElementID}`).show();
                    $(`#${errorElementID}`).hide();

                    if (callback && appendResponse) {
                        callback(...callbackParams, response);
                    }
                    else if (callback) {
                        callback(...callbackParams);
                    }

                    $("#access-key-message").text(response.message);
                    $("#access-key-value").text(response.key);

                }

                if (response.demo) {
                    $(`#demo-modal`).find('h5').text(response.demo).show();
                    $(`#demo-modal`).modal('show');
                }
            },
            error: function (response) {
                response = response.responseJSON;

                if (response.message) {
                    $(`#${errorElementID}`).text(response.message).show();
                    $(`#${successElementID}`).hide();
                }
                if (response.errors) {
                    fields.every(error => {
                        if (response.errors[error]) {

                            $(`#${errorElementID}`).text(response.errors[error][0]).show();

                            $(`#${successElementID}`).hide();

                            return false;
                        }
                        return true;

                    });

                }

                $(`#${successElementID}`).hide();
            }
        });

    }

    window.sendAjaxRequestShareResourceUrl = function sendAjaxRequestShareResourceUrl(formId, fields, successElementID, errorElementID, callback, callbackParams, appendResponse = false) {

        var form = document.getElementById(formId);
        let url = $(`#${formId}`).attr('data-url');
        $.ajax({
            type: "POST",
            url: url,
            data: new FormData(form),
            contentType: false,
            processData: false,
            dataType: "json",
            success: function (response) {
                if (response.message) {

                    $(`#${successElementID}`).show();
                    $(`#${errorElementID}`).hide();
                    $("#qr-code-confirm").hide();
                    $("#embed-confirm").hide();
                    if (callback && appendResponse) {
                        callback(...callbackParams, response);
                    }
                    else if (callback) {
                        callback(...callbackParams);
                    }

                    $("#share-resource-message").text("Resource Url");
                    $("#share-resource-url").text(response.url);

                }

                if (response.demo) {
                    $(`#demo-modal`).find('h5').text(response.demo).show();
                    $(`#demo-modal`).modal('show');
                }
            },
            error: function (response) {
                response = response.responseJSON;

                if (response.message) {
                    $(`#${errorElementID}`).text(response.message).show();
                    $(`#${successElementID}`).hide();
                }
                if (response.errors) {
                    fields.every(error => {
                        if (response.errors[error]) {

                            $(`#${errorElementID}`).text(response.errors[error][0]).show();

                            $(`#${successElementID}`).hide();

                            return false;
                        }
                        return true;

                    });

                }

                $(`#${successElementID}`).hide();
            }
        });

    }

    window.sendAjaxRequestQrCode = function sendAjaxRequestQrCode(formId, fields, successElementID, errorElementID, callback, callbackParams, appendResponse = false) {

        var form = document.getElementById(formId);
        let url = $(`#${formId}`).attr('data-url');
        $.ajax({
            type: "POST",
            url: url,
            data: new FormData(form),
            contentType: false,
            processData: false,
            dataType: "json",
            success: function (response) {
                if (response.message) {

                    $(`#${successElementID}`).show();
                    $(`#${errorElementID}`).hide();

                    if (callback && appendResponse) {
                        callback(...callbackParams, response);
                    }
                    else if (callback) {
                        callback(...callbackParams);
                    }

                    let qrCodeElement = document.getElementById("qr-code");

                    qrCodeElement.innerHTML = "";

                    new QRCode(qrCodeElement, {
                        text: response.url,
                        width: 200,
                        height: 200,
                        colorDark: "#000000",
                        colorLight: "#ffffff",
                        correctLevel: QRCode.CorrectLevel.H

                    });
                    $("#share-resource-url-confirm").hide();
                    $("#embed-confirm").hide();
                }

                if (response.demo) {
                    $(`#demo-modal`).find('h5').text(response.demo).show();
                    $(`#demo-modal`).modal('show');
                }
            },
            error: function (response) {
                response = response.responseJSON;

                if (response.message) {
                    $(`#${errorElementID}`).text(response.message).show();
                    $(`#${successElementID}`).hide();
                }
                if (response.errors) {
                    fields.every(error => {
                        if (response.errors[error]) {

                            $(`#${errorElementID}`).text(response.errors[error][0]).show();

                            $(`#${successElementID}`).hide();

                            return false;
                        }
                        return true;

                    });

                }

                $(`#${successElementID}`).hide();
            }
        });

    }

    window.sendAjaxRequestEmbedFile = function sendAjaxRequestEmbedFile(formId, fields, successElementID, errorElementID, callback, callbackParams, appendResponse = false, text) {

        var form = document.getElementById(formId);
        let url = $(`#${formId}`).attr('data-url');
        $.ajax({
            type: "POST",
            url: url,
            data: new FormData(form),
            contentType: false,
            processData: false,
            dataType: "json",
            success: function (response) {
                if (response.message) {

                    $(`#${successElementID}`).show();
                    $(`#${errorElementID}`).hide();

                    if (callback && appendResponse) {
                        callback(...callbackParams, response);
                    }
                    else if (callback) {
                        callback(...callbackParams);
                    }

                    $("#embed-url").attr('href', response.url);
                    $("#embed-url").text(text);

                    $("#share-resource-url-confirm").hide();
                    $("#qr-code-confirm").hide();
                }

                if (response.demo) {
                    $(`#demo-modal`).find('h5').text(response.demo).show();
                    $(`#demo-modal`).modal('show');
                }
            },
            error: function (response) {
                response = response.responseJSON;

                if (response.message) {
                    $(`#${errorElementID}`).text(response.message).show();
                    $(`#${successElementID}`).hide();
                }
                if (response.errors) {
                    fields.every(error => {
                        if (response.errors[error]) {

                            $(`#${errorElementID}`).text(response.errors[error][0]).show();

                            $(`#${successElementID}`).hide();

                            return false;
                        }
                        return true;

                    });

                }

                $(`#${successElementID}`).hide();
            }
        });

    }



    window.sendTestConnectionAjaxRequest = function sendTestConnectionAjaxRequest(formId, buttonID, fields, successElementID, errorElementID, callback, callbackParams = []) {

        var form = document.getElementById(formId);
        let url = $(`#${buttonID}`).attr('data-test');
        $.ajax({
            type: "POST",
            url: url,
            data: new FormData(form),
            contentType: false,
            processData: false,
            dataType: "json",
            beforeSend: function () {
                $('#global-loader').css('opacity', '0.5');
                $('#global-loader').show();
            },

            success: function (response) {
                if (response.message) {
                    $(`#${successElementID}`).text(response.message).show();
                    $(`#${errorElementID}`).hide();
                    if (callback)
                        callback(...callbackParams);
                }
                if (response.demo) {
                    $(`#demo-modal`).find('h5').text(response.demo).show();
                    // $(`.modal`).modal('hide');

                    $(`#demo-modal`).modal('show');
                }

            },
            error: function (response) {

                response = response.responseJSON;
                if (response.message) {
                    $(`#${errorElementID}`).text(response.message).show();
                }
                if (response.errors) {
                    fields.every(error => {
                        if (response.errors[error]) {

                            $(`#${errorElementID}`).text(response.errors[error][0]).show();

                            $(`#${successElementID}`).hide();

                            return false;
                        }
                        return true;

                    });

                }
                $("#saveBtn-add-dataconnection").attr("disabled", true);
                $(`#${successElementID}`).hide();
            }, complete: function () {
                $('#global-loader').css('opacity', '1');

                $('#global-loader').hide();

            }
        });

    }

    window.afterTestConnectionSuccess = function afterTestConnectionSuccess() {
        $("#saveBtn-add-dataconnection").attr("disabled", false);
    }

    window.afterEditTestConnectionSuccess = function afterEditTestConnectionSuccess() {
        $("#saveBtn-edit-dataconnection").attr("disabled", false);
        $("<input type='hidden' name='_method' value='PUT' />").appendTo('#edit-dataconnection-form');

    }



    window.sendAjaxRequestWithSuccess = function sendAjaxRequestWithSuccess(formId, modelToHide, callback, callbackParams, appendResponse = false) {

        var form = document.getElementById(formId);
        let url = $(`#${formId}`).attr('data-url');
        $.ajax({
            type: "POST",
            url: url,
            data: new FormData(form),
            contentType: false,
            processData: false,
            dataType: "json",
            beforeSend: function () {
                $('#global-loader').css('opacity', '0.5');
                $('#global-loader').show();
            },
            success: function (response) {
                if (response.message) {

                    $(`#${modelToHide}`).modal('hide');
                    $(`#success-modal`).find('h5').text(response.message).show();
                    $(`#success-modal`).modal('show');
                    if (callback && appendResponse)
                        callback(...callbackParams, response);
                    else if (callback) {
                        callback(...callbackParams);
                    }
                }

                if (response.demo) {
                    $(`#demo-modal`).find('h5').text(response.demo).show();
                    // $(`.modal`).modal('hide');

                    $(`#demo-modal`).modal('show');
                }


            }, error: function (response) {
                $(`#${modelToHide}`).modal('hide');
                $(`#success-modal`).find('h5').text(response.responseJSON.message).show();
                $(`#success-modal`).modal('show');

            }, complete: function () {
                $('#global-loader').css('opacity', '1');

                $('#global-loader').hide();

            }
        });

    }

    window.sendAjaxRequestWithErrorsAndWithSuccess = function sendAjaxRequestWithErrorsAndWithSuccess(formId, modelToHide, errorsElement, callback, callbackParams, appendResponse = false) {

        var form = document.getElementById(formId);
        let url = $(`#${formId}`).attr('data-url');
        $.ajax({
            type: "POST",
            url: url,
            data: new FormData(form),
            contentType: false,
            processData: false,
            dataType: "json",

            success: function (response) {
                if (response.message) {

                    $(`#${modelToHide}`).modal('hide');
                    $(`#${errorsElement}`).hide();
                    $(`#success-modal`).find('h5').text(response.message).show();
                    $(`#success-modal`).modal('show');

                    if (callback && appendResponse)
                        callback(...callbackParams, response);
                    else if (callback) {
                        callback(...callbackParams);
                    }
                }

                if (response.demo) {
                    $(`#demo-modal`).find('h5').text(response.demo).show();
                    // $(`.modal`).modal('hide');

                    $(`#demo-modal`).modal('show');
                }


            }, error: function (response) {
                $(`#${errorsElement}`).text(response.responseJSON.message).show();

            }, complete: function () {
                $('#global-loader').css('opacity', '1');

                $('#global-loader').hide();

            }
        });

    }




    window.reloadForm = function reloadForm(formId, location = window.location.href) {
        $.ajax({
            url: location,
            type: "GET",
            dataType: "html",
            success: function (data) {
                $(`#${formId}`).html($(data).find(`#${formId}`).html());

                $('[data-toggle="tooltip"]').tooltip({
                    boundary: 'window'
                })
            }
        });
    }

    window.reloadWithClass = function reloadWithClass(elementClass, location = window.location.href) {
        $.ajax({
            url: location,
            type: "GET",
            dataType: "html",
            success: function (data) {
                $(`.${elementClass}`).html($(data).find(`.${elementClass}`).html());
            }
        });
    }

    window.reloadUsersTable = function reloadUsersTable(tableId, operation, location = window.location.href) {

        let currentPage = 0;

        // Get current page before destroying
        if ($.fn.DataTable.isDataTable(`#${tableId}`)) {
            currentPage = $(`#${tableId}`).DataTable().page();
        }
        $.ajax({
            url: location,
            type: "GET",
            dataType: "html",
            success: function (data) {
                // Destroy the existing DataTable
                $(`#${tableId}`).DataTable().destroy();

                // Update the HTML content
                $(`#${tableId}`).html($(data).find(`#${tableId}`).html());

                // Reinitialize the DataTable
                let usersTable = $('#users').DataTable({
                    "dom": "lrtip",
                    "paging": true,
                    "pageLength": 10,
                    "lengthChange": false,
                    "searching": true,
                    "ordering": true,
                    "order": [],
                    "columnDefs": [{
                        "targets": 6,
                        "orderable": false
                    },
                    ],
                    "info": true,
                    "autoWidth": false,
                    "responsive": true,
                    "language": {
                        "zeroRecords": "No data matches your search criteria",
                    },
                    drawCallback: function (settings) {
                        var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
                        pagination.toggle(this.api().page.info().pages > 1);
                    },
                    initComplete: function (settings, json) {
                        const table = this.api();
                        const pageInfo = table.page.info();

                        if (pageInfo.pages > 1 && operation == "add") {
                            table.page(0).draw('page');
                        } else {
                            table.page(currentPage).draw('page');
                        }

                    }

                });

                applyuserSearch(usersTable);
                clearuserSearch(usersTable);

            }
        });
    }


    window.reloadGroupTable = function reloadGroupTable(tableId, operation, location = window.location.href) {
        let currentPage = 0;

        // Get current page before destroying
        if ($.fn.DataTable.isDataTable(`#${tableId}`)) {
            currentPage = $(`#${tableId}`).DataTable().page();
        }
        $.ajax({
            url: location,
            type: "GET",
            dataType: "html",
            success: function (data) {
                // Destroy the existing DataTable
                $(`#${tableId}`).DataTable().destroy();

                // Update the HTML content
                $(`#${tableId}`).html($(data).find(`#${tableId}`).html());

                // Reinitialize the DataTable
                let groupsTable = $(`#${tableId}`).DataTable({
                    "dom": "lrtip",
                    "paging": true,
                    "pageLength": 10,
                    "lengthChange": false,
                    "searching": true,
                    "ordering": false,
                    "order": [[1, "desc"]],
                    "columnDefs": [
                    {
                        "targets": 3,
                        "orderable": false
                    }
                    ],
                    "info": true,
                    "autoWidth": false,
                    "responsive": true,
                    "language": {
                        "zeroRecords": "No records matches your search criteria",
                        "emptyTable": "No groups to preview"

                    },
                    drawCallback: function (settings) {
                        var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
                        pagination.toggle(this.api().page.info().pages > 1);
                    },
                    initComplete: function (settings, json) {
                        const table = this.api();
                        const pageInfo = table.page.info();

                        if (pageInfo.pages > 1 && operation == "add") {
                            table.page('last').draw('page');
                        } else {
                            table.page(currentPage).draw('page');
                        }

                    }
                });

                window.applyGroupSearch(groupsTable);
                window.clearGroupSearch(groupsTable);
            }
        });
    }

    window.applyGroupSearch = function applyGroupSearch(groupsTable) {
        $('.search-filter').click(function () {
            groupsTable.column(0).search($('#search-groups').val());
            groupsTable.draw();

        });

    }

    window.clearGroupSearch = function clearGroupSearch(groupsTable) {
        $('.wrapper').on('click', '.reset-filter', function () {
            $('#search-groups').val("");
            groupsTable.columns().search("").draw();
        });

    }

    // categories
    window.reloadCategoryTable = function reloadCategoryTable(tableId, operation, location = window.location.href) {

        let currentPage = 0;

        // Get current page before destroying
        if ($.fn.DataTable.isDataTable(`#${tableId}`)) {
            currentPage = $(`#${tableId}`).DataTable().page();
        }
        $.ajax({
            url: location,
            type: "GET",
            dataType: "html",
            success: function (data) {
                // Destroy the existing DataTable
                $(`#${tableId}`).DataTable().destroy();

                // Update the HTML content
                $(`#${tableId}`).html($(data).find(`#${tableId}`).html());

                // Reinitialize the DataTable
                let categoryTable = $(`#${tableId}`).DataTable({
                    "dom": "lrtip",
                    "paging": true,
                    "pageLength": 10,
                    "lengthChange": false,
                    "searching": true,
                    "ordering": true,
                    "order": [],
                    "columnDefs": [{
                        "targets": 3,
                        "orderable": false
                    }
                    ],
                    "info": true,
                    "autoWidth": false,
                    "responsive": true,
                    "language": {
                        "zeroRecords": "No records matches your search criteria",
                        "emptyTable": "No categories to preview"

                    },
                    drawCallback: function (settings) {
                        var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
                        pagination.toggle(this.api().page.info().pages > 1);
                    },
                    initComplete: function (settings, json) {
                        const table = this.api();
                        const pageInfo = table.page.info();


                        if (pageInfo.pages > 1 && operation == "add") {
                            table.page('last').draw('page');
                        } else {
                            table.page(currentPage).draw('page');
                        }
                    }

                });

                window.applyCategorySearch(categoryTable);
                window.clearCategorySearch(categoryTable);
            }
        });
    }


    window.applyCategorySearch = function applyCategorySearch(categoriesTable) {
        $('.search-filter').click(function () {
            categoriesTable.column(0).search($('#search-categories').val());
            categoriesTable.draw();

        });


    }


    window.clearCategorySearch = function clearCategorySearch(categoriesTable) {
        $(document).on('click', '.reset-filter', function () {
            
            $('#search-categories').val("");
            categoriesTable.columns().search("").draw();
            categoriesTable.draw();
        });

    }

    window.reloadBarcodeTable = function reloadBarcodeTable(tableId, operation, location = window.location.href) {
        let currentPage = 0;

        // Get current page before destroying
        if ($.fn.DataTable.isDataTable(`#${tableId}`)) {
            currentPage = $(`#${tableId}`).DataTable().page();
        }
        $.ajax({
            url: location,
            type: "GET",
            dataType: "html",
            success: function (data) {
                // Destroy the existing DataTable
                $(`#${tableId}`).DataTable().destroy();

                // Update the HTML content
                $(`#${tableId}`).html($(data).find(`#${tableId}`).html());

                // Reinitialize the DataTable
                let barcodeTable = $(`#${tableId}`).DataTable({
                    "dom": "lrtip",
                    "paging": true,
                    "pageLength": 10,
                    "lengthChange": false,
                    "searching": true,
                    "ordering": true,
                    "order": [],
                    "columnDefs": [{
                        "targets": 3,
                        "orderable": false
                    }
                    ],
                    "info": true,
                    "autoWidth": false,
                    "responsive": true,
                    "language": {
                        "zeroRecords": "No records matches your search criteria",
                        "emptyTable": "No barcodes to preview"

                    },
                    drawCallback: function (settings) {
                        var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
                        pagination.toggle(this.api().page.info().pages > 1);
                    },
                    initComplete: function (settings, json) {
                        const table = this.api();
                        const pageInfo = table.page.info();

                        if (pageInfo.pages > 1 && operation == "add") {
                            table.page('last').draw('page');
                        } else {
                            table.page(currentPage).draw('page');
                        }
                    }

                });

                window.applyBarcodeSearch(barcodeTable);
                window.clearBarcodeSearch(barcodeTable);
            },
            complete: function () {
                document.querySelectorAll('div.barcode').forEach(div => {
                    const value = div.getAttribute('jsbarcode-value') || '';
                    let format = div.getAttribute('jsbarcode-format') || 'CODE128';


                    const barWidth = parseFloat(div.getAttribute('jsbarcode-barwidth')) || 2;
                    const barHeight = parseFloat(div.getAttribute('jsbarcode-barheight')) || 60;
                    const textAlign = div.getAttribute('jsbarcode-textalign') || 'center';
                    const fontOptions = div.getAttribute('jsbarcode-fontoptions') || 'bold';
                    const fontSize = div.getAttribute('jsbarcode-fontsize') || 20;
                    const displayValue = div.getAttribute('jsbarcode-displayvalue') !== '0';

                    // Clear existing content (optional, to avoid duplicates)
                    div.innerHTML = '';

                    // Create SVG element
                    const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");


                    // Append SVG inside the original div
                    div.appendChild(svg);

                    try {
                        JsBarcode(svg, value, {
                            format: format,
                            width: barWidth,
                            height: barHeight,
                            textAlign: textAlign,
                            fontOptions: fontOptions,
                            fontSize: fontSize,
                            displayValue: displayValue,
                            background: "#ffffff",
                            lineColor: "#000000"
                        });
                    } catch (e) {
                        div.innerHTML = value;
                    }
                });

            }
        });
    }


    window.applyBarcodeSearch = function applyBarcodeSearch(barcodesTable) {
        $('.search-filter').click(function () {
            barcodesTable.column(0).search($('#search-barcodes').val());
            barcodesTable.draw();

        });


    }


    window.clearBarcodeSearch = function clearBarcodeSearch(barcodesTable) {
        $('.wrapper').on('click', '.reset-filter', function () {
            $('#search-barcodes').val("");
            barcodesTable.columns().search("").draw();
        });

    }


    window.reloadAccessKeyTable = function reloadAccessKeyTable(tableId, operation, location = window.location.href) {
        let currentPage = 0;

        // Get current page before destroying
        if ($.fn.DataTable.isDataTable(`#${tableId}`)) {
            currentPage = $(`#${tableId}`).DataTable().page();
        }
        $.ajax({
            url: location,
            type: "GET",
            dataType: "html",
            success: function (data) {
                // Destroy the existing DataTable
                $(`#${tableId}`).DataTable().destroy();

                // Update the HTML content
                $(`#${tableId}`).html($(data).find(`#${tableId}`).html());

                // Reinitialize the DataTable
                let accessKeyTable = $(`#${tableId}`).DataTable({
                    "dom": "lrtip",
                    "paging": true,
                    "pageLength": 10,
                    "lengthChange": false,
                    "searching": true,
                    "ordering": true,
                    "order": [],
                    "columnDefs": [{
                        "targets": 4,
                        "orderable": false
                    },
                    ],
                    "info": true,
                    "autoWidth": false,
                    "responsive": true,
                    "language": {
                        "zeroRecords": "No records matches your search criteria",
                        "emptyTable": "No access keys to preview"

                    },
                    drawCallback: function (settings) {
                        var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
                        pagination.toggle(this.api().page.info().pages > 1);
                    },
                    initComplete: function (settings, json) {
                        const table = this.api();
                        const pageInfo = table.page.info();

                        // if (pageInfo.pages > 1 && operation == "add") {
                        //     table.page('last').draw('page');
                        // } else {
                        //     table.page(currentPage).draw('page');
                        // }
                    }

                });

                window.ApplyAccessKeySearch(accessKeyTable);
                window.clearAccessKeySearch(accessKeyTable);
            }
        });
    }


    window.ApplyAccessKeySearch = function ApplyAccessKeySearch(accessKeyTable) {
        $('.search-filter').click(function () {
            accessKeyTable.column(0).search($('#search-access-keys').val());
            accessKeyTable.draw();

        });


    }


    window.clearAccessKeySearch = function clearAccessKeySearch(accessKeyTable) {
        $('.wrapper').on('click', '.reset-filter', function () {
            $('#search-access-keys').val("");
            accessKeyTable.columns().search("").draw();
        });

    }



    // data connections
    window.applyDataConnectionSearch = function applyDataConnectionSearch(dataConnectionTable) {
        $('.search-filter').click(function () {
            dataConnectionTable.column(0).search($('#connection-name-search').val());
            dataConnectionTable.column(1).search($('#db-type-search').val());
            dataConnectionTable.column(2).search($('#servers-search').val());
            dataConnectionTable.column(3).search($('#databases-search').val());
            dataConnectionTable.draw();

        });


    }

    window.clearDataConnectionSearch = function clearDataConnectionSearch(dataConnectionTable) {
        $('.wrapper').on('click', '.reset-filter', function () {
            $('#connection-name-search').val("");
            $('#db-type-search option:first').prop('selected', true);
            $('#servers-search option:first').prop('selected', true);
            $('#databases-search option:first').prop('selected', true);

            dataConnectionTable.columns().search("").draw();
        });

    }


    window.reloadDataConnectionTable = function reloadDataConnectionTable(tableId, operation, location = window.location.href) {
        let currentPage = 0;

        // Get current page before destroying
        if ($.fn.DataTable.isDataTable(`#${tableId}`)) {
            currentPage = $(`#${tableId}`).DataTable().page();
        }

        $.ajax({
            url: location,
            type: "GET",
            dataType: "html",
            success: function (data) {
                // Destroy the existing DataTable
                $(`#${tableId}`).DataTable().destroy();

                // Update the HTML content
                $(`#${tableId}`).html($(data).find(`#${tableId}`).html());

                // Reinitialize the DataTable
                let DataConnectionTable = $('#data-connections').DataTable({
                    "dom": "lrtip",
                    "paging": true,
                    "pageLength": 10,
                    "lengthChange": false,
                    "searching": true,
                    "ordering": true,
                    "order": [],
                    "columnDefs": [{
                        "targets": 5,
                        "orderable": false
                    },
                    ],
                    "info": true,
                    "autoWidth": false,
                    "responsive": true,
                    "language": {
                        "zeroRecords": "No data matches your search criteria",
                    },
                    drawCallback: function (settings) {
                        var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
                        pagination.toggle(this.api().page.info().pages > 1);
                    },
                    initComplete: function (settings, json) {
                        const table = this.api();
                        const pageInfo = table.page.info();

                        if (pageInfo.pages > 1 && operation == "add") {
                            table.page(0).draw('page');
                        } else {
                            table.page(currentPage).draw('page');
                        }
                    }

                });

                applyDataConnectionSearch(DataConnectionTable);
                clearDataConnectionSearch(DataConnectionTable);

            }
        });
    }


    window.sendTestSMTPConnectionAjaxRequest = function sendTestSMTPConnectionAjaxRequest(formId, buttonID, fields, successElementID, errorElementID, callback, callbackParams = []) {

        var form = document.getElementById(formId);
        let url = $(`#${buttonID}`).attr('data-test');
        $.ajax({
            type: "POST",
            url: url,
            data: new FormData(form),
            contentType: false,
            processData: false,
            dataType: "json",
            beforeSend: function () {

                $("#global-loader").css('opacity', '0.5');
                $("#global-loader").fadeIn();
            },
            success: function (response) {
                if (response.message) {
                    $(`#${successElementID}`).text(response.message).show();
                    $(`#${errorElementID}`).hide();
                    if (callback)
                        callback(...callbackParams);
                    $("#saveBtn-smtp-server").attr("disabled", false);
                }

                if (response.demo) {
                    $(`#demo-modal`).find('h5').text(response.demo).show();
                    $(`#demo-modal`).modal('show');
                }


            },
            error: function (response) {

                response = response.responseJSON;
                if (response.message) {
                    $(`#${errorElementID}`).attr('title', response.message);
                    $(`#${errorElementID}`).text(prepareMessage(response.message, 100).truncatedMsg).show();
                }
                if (response.errors) {
                    fields.every(error => {
                        if (response.errors[error]) {

                            $(`#${errorElementID}`).attr('title', response.errors[error][0]);

                            $(`#${errorElementID}`).text(response.errors[error][0]).show();

                            $(`#${successElementID}`).hide();

                            return false;
                        }
                        return true;

                    });

                }
                $("#saveBtn-smtp-server").attr("disabled", true);
                $(`#${successElementID}`).hide();
            },
            complete: function () {
                $("#global-loader").css('opacity', '1');

                $("#global-loader").fadeOut();
            },

        });

    }


    window.sendSMTPConnectionAjaxRequest = function sendSMTPConnectionAjaxRequest(formId, fields, successElementID, errorElementID, callback, callbackParams) {

        var form = document.getElementById(formId);
        let url = $(`#${formId}`).attr('data-url');
        $.ajax({
            type: "POST",
            url: url,
            data: new FormData(form),
            contentType: false,
            processData: false,
            dataType: "json",
            beforeSend: function () {

                $("#global-loader").css('opacity', '0.5');
                $("#global-loader").fadeIn();
            },

            success: function (response) {
                if (response.message) {
                    $(`#${successElementID}`).text(response.message).show();
                    $(`#${errorElementID}`).hide();
                    if (callback)
                        callback(...callbackParams);
                }

                if (response.demo) {
                    $(`#demo-modal`).find('h5').text(response.demo).show();
                    $(`#demo-modal`).modal('show');
                }

            },
            error: function (response) {
                response = response.responseJSON;

                if (response.message === "need-confirmation") {
                    $('#smtp-confirm-modal').modal('show')
                }

                else {
                    if (response.message) {
                        $(`#${errorElementID}`).text(response.message).show();
                        $(`#${successElementID}`).hide();
                    }
                    if (response.errors) {
                        fields.every(error => {
                            if (response.errors[error]) {

                                $(`#${errorElementID}`).text(response.errors[error][0]).show();

                                $(`#${successElementID}`).hide();

                                return false;
                            }
                            return true;

                        });

                    }
                }

                $(`#${successElementID}`).hide();
            },
            complete: function () {
                $("#global-loader").css('opacity', '1');

                $("#global-loader").fadeOut();
            },
        });

    }


    // reports

    window.applyReportsSearch = function applyReportsSearch(reportsTable) {
        $('.search-filter').click(function () {
            reportsTable.column(0).search($('#report-name-search').val());
            reportsTable.column(1).search($('#category-search').val());
            reportsTable.column(3).search($('#creator-search').val());
            reportsTable.draw();
        });

    }

    window.clearReportsSearch = function clearReportsSearch(reportsTable) {
        $('.wrapper').on('click', '.reset-filter', function () {
            $('#report-name-search').val("");
            $('#category-search option:first').prop('selected', true);
            $('#creator-search option:first').prop('selected', true);

            reportsTable.columns().search("").draw();
        });

    }



    window.reloadReportTable = function reloadReportTable(tableId, location = window.location.href) {
        var collapsedGroups = {};

        $.ajax({
            url: location,
            type: "GET",
            dataType: "html",
            success: function (data) {
                // Destroy the existing DataTable
                $(`#${tableId}`).DataTable().destroy();

                // Update the HTML content
                $(`#${tableId}`).html($(data).find(`#${tableId}`).html());

                // Reinitialize the DataTable
                let reportsTable = $('#reports').DataTable({
                    "dom": "lrtip",
                    "paging": true,
                    "orderFixed": [2, 'asc'],
                    "pageLength": 10,
                    "lengthChange": false,
                    "searching": true,
                    "ordering": true,
                    "order": [],
                    "columnDefs": [{
                        "targets": 6,
                        "orderable": false
                    },
                    {
                        "targets": 1,
                        "visible": false,
                    },
                    {
                        "targets": 2,
                        "visible": false,
                    }
                    ],
                    "info": true,
                    "autoWidth": false,
                    "responsive": true,
                    "language": {
                        "zeroRecords": "No records matches your search criteria",
                        "emptyTable": "No reports to preview"
                    },
                    rowGroup: {
                        dataSrc: 1,
                        startRender: function (rows, group) {
                            var isFirstGroup = Object.keys(collapsedGroups).length === 0;

                            if (isFirstGroup) {
                                collapsedGroups[group] = false;
                            } else if (collapsedGroups[group] === undefined) {
                                collapsedGroups[group] = true;
                            }

                            var collapsed = collapsedGroups[group];

                            rows.nodes().each(function (r) {
                                r.style.display = collapsed ? 'none' : '';
                            });

                            if (group.includes('</i>')) {
                                trimmedGroup = group.substring(group.indexOf('</i>') + 4).trim();
                            }
                            return $('<tr/>')
                                .addClass('group-start')
                                .append(
                                    `<td colspan="6">
                                    <span class="group-toggle-box">
                                        <div class="toggle-box">${collapsed ? '+' : '-'}</div>
                                    </span>
                                    ${group}
                                </td>`
                                )
                                .toggleClass('collapsed', collapsed)
                                .attr('data-name', trimmedGroup)
                                .attr('data-icon', group);

                        }
                    },
                    drawCallback: function (settings) {
                        var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
                        pagination.toggle(this.api().page.info().pages > 1);
                    }

                });


                $('#reports tbody').on('click', 'tr.group-start', function () {
                    var tr = $(this);
                    var name = tr.attr('data-icon');
                    var isCollapsed = collapsedGroups[name];

                    collapsedGroups[name] = !isCollapsed;

                    // Update the toggle box text directly
                    tr.find('.toggle-box').text(isCollapsed ? '-' : '+');

                    var rows = reportsTable.rows({ search: 'applied' }).nodes();
                    $(rows).each(function () {
                        var rowGroup = reportsTable.cell(this, 1).data();
                        if (rowGroup === name) {
                            $(this).css('display', isCollapsed ? '' : 'none');
                        }
                    });
                });


                applyReportsSearch(reportsTable);
                clearReportsSearch(reportsTable);

            }
        });
    }

    // pivot tables

    window.applyPivotTableSearch = function applyPivotTableSearch(pivotTables) {
        $('.search-filter').click(function () {
            pivotTables.column(0).search($('#pivot-table-name-search').val());
            pivotTables.column(1).search($('#category-search').val());
            pivotTables.column(3).search($('#creator-search').val());
            pivotTables.draw();
        });

    }

    window.clearPivotTableSearch = function clearPivotTableSearch(pivotTables) {
        $('.wrapper').on('click', '.reset-filter', function () {
            $('#pivot-table-name-search').val("");
            $('#category-search option:first').prop('selected', true);
            $('#creator-search option:first').prop('selected', true);

            pivotTables.columns().search("").draw();
        });

    }



    window.reloadPivotTable = function reloadPivotTable(tableId, location = window.location.href) {
        var collapsedGroups = {};

        $.ajax({
            url: location,
            type: "GET",
            dataType: "html",
            success: function (data) {
                // Destroy the existing DataTable
                $(`#${tableId}`).DataTable().destroy();

                // Update the HTML content
                $(`#${tableId}`).html($(data).find(`#${tableId}`).html());

                // Reinitialize the DataTable
                let pivotTables = $('#pivot-tables').DataTable({
                    "dom": "lrtip",
                    "paging": true,
                    "orderFixed": [2, 'asc'],
                    "pageLength": 10,
                    "lengthChange": false,
                    "searching": true,
                    "ordering": true,
                    "order": [],
                    "columnDefs": [{
                        "targets": 6,
                        "orderable": false
                    },
                    {
                        "targets": 1,
                        "visible": false,
                    },
                    {
                        "targets": 2,
                        "visible": false,
                    }
                    ],
                    "info": true,
                    "autoWidth": false,
                    "responsive": true,
                    "language": {
                        "zeroRecords": "No records matches your search criteria",
                        "emptyTable": "No pivot table to preview"
                    },
                    rowGroup: {
                        dataSrc: 1,
                        startRender: function (rows, group) {
                            var isFirstGroup = Object.keys(collapsedGroups).length === 0;

                            if (isFirstGroup) {
                                collapsedGroups[group] = false;
                            } else if (collapsedGroups[group] === undefined) {
                                collapsedGroups[group] = true;
                            }

                            var collapsed = collapsedGroups[group];

                            rows.nodes().each(function (r) {
                                r.style.display = collapsed ? 'none' : '';
                            });

                            if (group.includes('</i>')) {
                                trimmedGroup = group.substring(group.indexOf('</i>') + 4).trim();
                            }
                            return $('<tr/>')
                                .addClass('group-start')
                                .append(
                                    `<td colspan="5">
                                    <span class="group-toggle-box">
                                        <div class="toggle-box">${collapsed ? '+' : '-'}</div>
                                    </span>
                                    ${group}
                                </td>`
                                )
                                .toggleClass('collapsed', collapsed)
                                .attr('data-name', trimmedGroup)
                                .attr('data-icon', group);

                        }
                    },
                    drawCallback: function (settings) {
                        var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
                        pagination.toggle(this.api().page.info().pages > 1);
                    }

                });


                $('#pivot-tables tbody').on('click', 'tr.group-start', function () {
                    var tr = $(this);
                    var name = tr.attr('data-icon');
                    var isCollapsed = collapsedGroups[name];

                    collapsedGroups[name] = !isCollapsed;

                    // Update the toggle box text directly
                    tr.find('.toggle-box').text(isCollapsed ? '-' : '+');

                    var rows = pivotTables.rows({ search: 'applied' }).nodes();
                    $(rows).each(function () {
                        var rowGroup = pivotTables.cell(this, 1).data();
                        if (rowGroup === name) {
                            $(this).css('display', isCollapsed ? '' : 'none');
                        }
                    });
                });


                applyPivotTableSearch(pivotTables);
                clearPivotTableSearch(pivotTables);

            }
        });
    }


    window.applyScheduledReportsSearch = function applyScheduledReportsSearch(scheduledReportsTable) {
        $('.search-filter').click(function () {
            scheduledReportsTable.column(0).search($('#title-search').val());
            scheduledReportsTable.column(1).search($('#frequency-search').val());
            scheduledReportsTable.draw();
        });

    }

    window.clearScheduledReportsSearch = function clearReportsSearch(scheduledReportsTable) {
        $('.wrapper').on('click', '.reset-filter', function () {
            $('#title-search').val("");
            $('#frequency-search option:first').prop('selected', true);

            scheduledReportsTable.columns().search("").draw();
        });

    }

    window.reloadScheduledReportsTable = function reloadScheduledReportsTable(tableId, location = window.location.href) {
        $.ajax({
            url: location,
            type: "GET",
            dataType: "html",
            success: function (data) {
                // Destroy the existing DataTable
                $(`#${tableId}`).DataTable().destroy();

                // Update the HTML content
                $(`#${tableId}`).html($(data).find(`#${tableId}`).html());

                // Reinitialize the DataTable
                let scheduledReportsTable = $('#scheduled-reports').DataTable({
                    "dom": "lrtip",
                    "paging": true,
                    "pageLength": 10,
                    "lengthChange": false,
                    "searching": true,
                    "ordering": true,
                    "order": [],
                    "columnDefs": [{
                        "targets": 5,
                        "orderable": false
                    },
                    ],
                    "info": true,
                    "autoWidth": false,
                    "responsive": true,
                    "language": {
                        "zeroRecords": "No records matches your search criteria",
                        "emptyTable": "No scheduled reports to preview"
                    },
                    drawCallback: function (settings) {
                        var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
                        pagination.toggle(this.api().page.info().pages > 1);
                    }

                });

                applyScheduledReportsSearch(scheduledReportsTable);
                clearScheduledReportsSearch(scheduledReportsTable);

            }
        });
    }



    // Access Logs


    window.applyAccessLogsSearch = function applyAccessLogsSearch(accessLogsTable) {
        $.fn.dataTable.ext.search.push(function (settings, data, dataIndex) {
            var min = $('#from-date').val();
            var max = $('#to-date').val();
            var dateStr = data[3]; // column index 3 (your datetime column)
            
            if (!dateStr) return false;

            var date = new Date(dateStr);

            // Normalize min to start of day
            var minDate = min ? new Date(min + " 00:00:00") : null;

            // Normalize max to end of day
            var maxDate = max ? new Date(max + " 23:59:59") : null;

            // Compare
            if (
                (!minDate && !maxDate) ||
                (!minDate && date <= maxDate) ||
                (minDate <= date && !maxDate) ||
                (minDate <= date && date <= maxDate)
            ) {
                return true;
            }
            return false;
        });

        $('.search-filter').click(function () {
            // IP filter on column 0
            accessLogsTable.column(1).search($('#ipaddress-search').val());
            accessLogsTable.column(2).search($('#origin-search').val());

            // redraw will trigger custom date range filter too
            accessLogsTable.draw();
        });
    };

    window.clearAccessLogsSearch = function clearAccessLogsSearch(accessLogsTable) {
        $(document).on('click', '.reset-filter', function () {
            $('#ipaddress-search').val("");
            $('#origin-search').val("");
            $('#from-date').val("");
            $('#to-date').val("");

            accessLogsTable.columns().search("").draw();
        });

    }

    window.reloadAccessLogsTable = function reloadAccessLogsTable(tableId, location = window.location.href) {
        $.ajax({
            url: location,
            type: "GET",
            dataType: "html",
            success: function (data) {
                // Destroy the existing DataTable
                $(`#${tableId}`).DataTable().destroy();

                // Update the HTML content
                $(`#${tableId}`).html($(data).find(`#${tableId}`).html());

                // Reinitialize the DataTable
                let accessLogsTable = $('#access-logs').DataTable({
                    "dom": "lrtip",
                    "paging": true,
                    "pageLength": 10,
                    "lengthChange": false,
                    "searching": true,
                    "ordering": true,
                    "order": [],
                    "columnDefs": [{
                        "targets": 5,
                        "orderable": false
                    },
                    ],
                    "info": true,
                    "autoWidth": false,
                    "responsive": true,
                    "language": {
                        "zeroRecords": "No records matches your search criteria",
                        "emptyTable": "No access logs to preview"
                    },
                    drawCallback: function (settings) {
                        var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
                        pagination.toggle(this.api().page.info().pages > 1);
                    }

                });

                applyAccessLogsSearch(accessLogsTable);
                clearAccessLogsSearch(accessLogsTable);

            }
        });
    }


    window.applyDashboardsSearch = function applyDashboardsSearch(DashboardsTable) {
        $('.search-filter').click(function () {
            DashboardsTable.column(0).search($('#name-search').val());
            DashboardsTable.column(1).search($('#title-search').val());
            DashboardsTable.draw();
        });

    }

    window.clearDashboardsSearch = function clearDashboardsSearch(DashboardsTable) {
        $('.wrapper').on('click', '.reset-filter', function () {
            $('#name-search').val("");
            $('#title-search').val("");

            DashboardsTable.columns().search("").draw();
        });

    }


    window.reloadDashboardsTable = function reloadDashboardsTable(tableId, location = window.location.href) {
        let currentPage = 0;

        // Get current page before destroying
        if ($.fn.DataTable.isDataTable(`#${tableId}`)) {
            currentPage = $(`#${tableId}`).DataTable().page();
        }
        $.ajax({
            url: location,
            type: "GET",
            dataType: "html",
            success: function (data) {
                // Destroy the existing DataTable
                $(`#${tableId}`).DataTable().destroy();

                // Update the HTML content
                $(`#${tableId}`).html($(data).find(`#${tableId}`).html());

                // Reinitialize the DataTable
                let DashboardsTable = $('#dashboards').DataTable({
                    "dom": "lrtip",
                    "paging": true,
                    "pageLength": 10,
                    "lengthChange": false,
                    "searching": true,
                    "ordering": true,
                    "order": [],
                    "columnDefs": [{
                        "targets": 4,
                        "orderable": false
                    },
                    ],
                    "info": true,
                    "autoWidth": false,
                    "responsive": true,
                    "language": {
                        "zeroRecords": "No records matches your search criteria",
                        "emptyTable": "No dashboards stored for this user account"

                    },
                    drawCallback: function (settings) {
                        var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
                        pagination.toggle(this.api().page.info().pages > 1);
                    },
                    initComplete: function (settings, json) {
                        const table = this.api();
                        const pageInfo = table.page.info();

                        if (pageInfo.pages > 1 && typeof operation !== 'undefined' && operation == "add") {
                            table.page(0).draw('page');
                        } else {
                            table.page(currentPage).draw('page');
                        }
                    }

                });

                applyDashboardsSearch(DashboardsTable);
                clearDashboardsSearch(DashboardsTable);

            }
        });
    }



    window.reloadChartPage = function reloadChartPage(location = window.location.href) {
        $.ajax({
            url: location,
            type: "GET",
            dataType: "html",
            success: function (data) {
                window.location.href = window.location.href;

            }
        });
    }

    window.reloadPagePartially = function reloadPagePartially(formId = null, reloadedPart, reloadedIn, isQuery = false, url = window.location.href) {

        if (!isQuery)
            url = url.split("?")[0];

        if (formId)
            var form = $(`#${formId}`);
        $.ajax({
            type: "GET",
            url: url,
            data: formId ? form.serialize() : "",
            dataType: "html",
            beforeSend: function () {
                $(reloadedIn).css("visibility", "hidden");
                $(".c3-legend-item").css("visibility", "hidden")
                $(reloadedIn).parent().addClass('spinner');
            },
            success: function (data) {

                let response = $(data).find(reloadedPart).html();
                $(reloadedIn).html(response);
                $(reloadedIn).css("visibility", "visible");
                $(".c3-legend-item").css("visibility", "visible");

                let test = window.showInHomePivotTable(function () {
                    window.changePivotTitle();
                    $("#pivot-title").remove();
                });

                test.then(function (result) {

                });

                $(window).trigger('resize');

                // reload custom tooltip
                $('[data-toggle="custom-tooltip"]').tooltip({
                    html: true,
                    template: '<div class="tooltip custom-tooltip" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'
                });
            },
            complete: function () {
                $(reloadedIn).parent().removeClass('spinner');
            },

            error: function () {

            }
        });

    }



    window.reloadPageWithSearch = function reloadPageWithSearch(formId = null, reloadedPart, reloadedIn, isQuery = false, url = window.location.href) {
        if (!isQuery)
            url = url.split("?")[0];

        if (formId)
            var form = $(`#${formId}`);
        $.ajax({
            type: "GET",
            url: url,
            data: formId ? form.serialize() : "",
            dataType: "html",
            beforeSend: function () {
                $(reloadedIn).css("visibility", "hidden");
                $(".c3-legend-item").css("visibility", "hidden")
                $(reloadedIn).parent().addClass('spinner');
            },
            success: function (data) {

                let response = $(data).find(reloadedPart).html();
                $(reloadedIn).html(response);
                $(reloadedIn).css("visibility", "visible");
                $(".c3-legend-item").css("visibility", "visible");


                $(window).trigger('resize');

                // reload custom tooltip
                $('[data-toggle="custom-tooltip"]').tooltip({
                    html: true,
                    template: '<div class="tooltip custom-tooltip" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'
                });
            },
            complete: function () {
                $(reloadedIn).parent().removeClass('spinner');
            },

            error: function () {

            }
        });

    }



    window.reloadChartPagePartially = function reloadChartPagePartially(reloadedPart, reloadedIn, lastPage) {

        url = window.location.href;
        try {
            currentPage = url.split("?")[1].split("=")[1];
        } catch (error) {
            currentPage = 1;

        }

        if (lastPage != null) {
            if (lastPage < +currentPage) {
                const newUrl = new URL(window.location);

                url = typeof lastPage === 'object' ? url + "?page=" + lastPage.last_page : url + "?page=" + lastPage;

                typeof lastPage === 'object' ? newUrl.searchParams.set('page', lastPage.last_page) : newUrl.searchParams.set('page', lastPage)

                window.history.replaceState({}, document.title, newUrl);
            }
        } else {
            currentPage = 1;
            url = url + "?page=" + currentPage;
        }

        $.ajax({
            type: "GET",
            url: url,
            dataType: "html",
            beforeSend: function () {
                $(reloadedIn).css("visibility", "hidden");
                $(reloadedIn).parent().addClass('spinner');
            },
            success: function (data) {
                let response = $(data).find(reloadedPart).html();
                $(reloadedIn).html(response);
                $(reloadedIn).css("visibility", "visible");

                $(window).trigger('resize');

                // reload custom tooltip
                $('[data-toggle="custom-tooltip"]').tooltip({
                    html: true,
                    template: '<div class="tooltip custom-tooltip" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'
                });

            },
            complete: function () {
                $(reloadedIn).parent().removeClass('spinner');
            },

            error: function () {

            }
        });


    }




    window.reloadMetricPagePartially = function reloadMetricPagePartially(reloadedPart, reloadedIn, goToLast = true, lastPage = null) {

        url = window.location.href;
        try {
            currentPage = url.split("?")[1].split("=")[1];
        } catch (error) {
            currentPage = 1;

        }

        url = url.split("?")[0];

        if (lastPage != null) {
            if (lastPage < +currentPage || goToLast) {
                const newUrl = new URL(window.location);

                url = typeof lastPage === 'object' ? url + "?page=" + lastPage.last_page : url + "?page=" + lastPage;

                typeof lastPage === 'object' ? newUrl.searchParams.set('page', lastPage.last_page) : newUrl.searchParams.set('page', lastPage)

                window.history.replaceState({}, document.title, newUrl);
            }
        }

        $.ajax({
            type: "GET",
            url: url,
            dataType: "html",
            beforeSend: function () {
                $(reloadedIn).css("visibility", "hidden");
                $(".c3-legend-item").css("visibility", "hidden")
                $(reloadedIn).parent().addClass('spinner');
            },
            success: function (data) {

                let response = $(data).find(reloadedPart).html();
                $(reloadedIn).html(response);
                $(reloadedIn).css("visibility", "visible");
                $(".c3-legend-item").css("visibility", "visible");


                $(window).trigger('resize');

                // reload custom tooltip
                $('[data-toggle="custom-tooltip"]').tooltip({
                    html: true,
                    template: '<div class="tooltip custom-tooltip" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'
                });

            },
            complete: function () {
                $(reloadedIn).parent().removeClass('spinner');
            },

            error: function () {

            }
        });

    }


    window.reloadHomePagePartially = function reloadHomePagePartially(reloadedPart, reloadedIn, goToLast = true, lastPage = null) {

        url = window.location.href;
        try {
            currentPage = url.split("?")[1].split("=")[1];
        } catch (error) {
            currentPage = 1;

        }
        url = url.split("?")[0]

        if (lastPage != null) {

            lastPage = typeof lastPage === 'object' ? lastPage.last_page : lastPage;

            if (lastPage < +currentPage || goToLast) {
                const newUrl = new URL(window.location);

                url = url + "?page=" + lastPage;

                newUrl.searchParams.set('page', lastPage)

                window.history.replaceState({}, document.title, newUrl);


            } else {

                url = url + "?page=" + currentPage;

            }
        }

        $.ajax({
            type: "GET",
            url: url,
            dataType: "html",
            beforeSend: function () {
                $(reloadedIn).css("visibility", "hidden");
                $(".c3-legend-item").css("visibility", "hidden")
                $(reloadedIn).parent().addClass('spinner');
            },
            success: function (data) {

                let response = $(data).find(reloadedPart).html();
                $(reloadedIn).html(response);
                $(reloadedIn).css("visibility", "visible");
                $(".c3-legend-item").css("visibility", "visible");

                window.showInHomePivotTable(function () {
                    window.changePivotTitle();
                    $("#pivot-title").remove();
                });

                $(window).trigger('resize');

                // reload custom tooltip
                $('[data-toggle="custom-tooltip"]').tooltip({
                    html: true,
                    template: '<div class="tooltip custom-tooltip" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'
                });

            },
            complete: function () {
                $(reloadedIn).parent().removeClass('spinner');
            },

            error: function () {

            }
        });

    }



    window.sendStartTourRequest = function sendStartTourRequest() {
        let url = $('#start-tour').data('start');
        $.ajax({
            url: url,
            type: 'POST',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            success: function () {
            },
            error: function (xhr, status, error) {
            }
        });

    }

    window.sendStopTourRequest = function sendStopTourRequest() {
        let url = $('#start-tour').data('stop');
        $.ajax({
            url: url,
            type: 'POST',
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            success: function () {
            },
            error: function (xhr, status, error) {
            }
        });

    }

    window.sendTourStepRequest = function sendTourStepRequest(step) {
        let url = $('#start-tour').data('step');
        $.ajax({
            url: url,
            type: 'POST',
            data: { 'step': step },
            headers: { 'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content') },
            success: function () {
            },
            error: function (xhr, status, error) {
            }
        });

    }



    window.prepareMessage = function prepareMessage(msg, length) {

        if (msg.length > length)
            return {
                fullMsg: msg,
                truncatedMsg: `${msg.substring(0, length)}...`
            };
        else {
            return {
                fullMsg: msg,
                truncatedMsg: msg,
            };
        }

    }


    window.vh = function vh(percent) {
        var h = Math.max(document.documentElement.clientHeight, window.innerHeight || 0);
        return (percent * h) / 100;
    }
    window.vw = function vw(percent) {
        var w = Math.max(document.documentElement.clientWidth, window.innerWidth || 0);
        return (percent * w) / 100;
    }


    window.adjustModalHeight = function adjustModalHeight(id) {
        var iFrameID = document.getElementById(id);

        function setIframeHeight(event) {
            // Check if the event target is a textbox, textarea, or select box
            if (event && (
                (event.target.tagName === "INPUT" && event.target.type === "text") ||
                (event.target.tagName === "INPUT" && event.target.type === "radio") ||
                event.target.tagName === "TEXTAREA" || event.target.tagName === "SELECT"
                || event.target.tagName === "OPTION" || event.target.tagName === "DIV"
            )) {
                return; // Do not adjust height if clicking inside a textbox, textarea, or select box
            }

            iFrameID.style.height = "200px"; // Set a default height
            iFrameID.style.height = (iFrameID.contentWindow.document.body.scrollHeight) + "px";
        }

        if (iFrameID) {
            // Initial height setting
            setIframeHeight();

            // Event listeners for commonly used events (you can adjust this based on your needs)
            iFrameID.contentWindow.addEventListener("load", setIframeHeight); // Adjust on load
            iFrameID.contentWindow.addEventListener("click", setIframeHeight); // Adjust on click

            const iframeBody = iFrameID.contentDocument.body;

            // ResizeObserver to continuously monitor changes
            const ro = new ResizeObserver(function () {
                if (iframeBody.scrollHeight < vh(10)) {
                    iFrameID.style.height = "500px"; // Set a minimum height
                } else {
                    iFrameID.style.height = `${iframeBody.scrollHeight}px`;
                }
            });

            ro.observe(iframeBody);
        }
    };


    window.setCookie = function setCookie(key, value, expiry) {
        var expires = new Date();
        expires.setTime(expires.getTime() + (expiry * 24 * 60 * 60 * 1000));
        document.cookie = key + '=' + value + ';expires=' + expires.toUTCString();
    }

    window.getCookie = function getCookie(key) {
        var keyValue = document.cookie.match('(^|;) ?' + key + '=([^;]*)(;|$)');
        return keyValue ? keyValue[2] : null;
    }

    window.eraseCookie = function eraseCookie(key) {
        var keyValue = getCookie(key);
        setCookie(key, keyValue, '-1');
    }
});
