$(function () {
    let groupsTable = $('#groups').DataTable({
        "dom": "lrtip",
        "paging": true,
        "orderFixed": [1, 'asc'],
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [[1, "desc"]],
        "columnDefs": [{
            "targets": 3,
            "orderable": false
        },
        {
            "targets": 1,
            "visible": false
        }
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No records matches your search criteria",
            "emptyTable": "No groups to preview"
        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }

    });

    window.applyGroupSearch(groupsTable);
    window.clearGroupSearch(groupsTable);

    var categoriesTable = $('#categories').DataTable({
        "dom": "lrtip",
        "paging": true,
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [],
        "columnDefs": [{
            "targets": 3,
            "orderable": false
        }
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No records matches your search criteria",
            "emptyTable": "No categories to preview"

        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }

    });

    window.applyCategorySearch(categoriesTable);
    window.clearCategorySearch(categoriesTable);


    var barcodesTable = $('#barcodes').DataTable({
        "dom": "lrtip",
        "paging": true,
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [],
        "columnDefs": [{
            "targets": 3,
            "orderable": false
        }
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No records matches your search criteria",
            "emptyTable": "No barcode definitions to preview"

        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }

    });

    barcodesTable.on('draw.dt', function () {
        document.querySelectorAll('div.barcode').forEach(div => {
            const value = div.getAttribute('jsbarcode-value') || '';
            let format = div.getAttribute('jsbarcode-format') || 'CODE128';


            const barWidth = parseFloat(div.getAttribute('jsbarcode-barwidth')) || 2;
            const barHeight = parseFloat(div.getAttribute('jsbarcode-barheight')) || 60;
            const textAlign = div.getAttribute('jsbarcode-textalign') || 'center';
            const fontSize = div.getAttribute('jsbarcode-fontsize') || 20;
            const fontOptions = div.getAttribute('jsbarcode-fontoptions') || 'bold';
            const displayValue = div.getAttribute('jsbarcode-displayvalue') !== '0';

            // Clear existing content (optional, to avoid duplicates)
            div.innerHTML = '';

            const svg = document.createElementNS("http://www.w3.org/2000/svg", "svg");

            div.appendChild(svg);

            try {
                JsBarcode(svg, value, {
                    format: format,
                    width: barWidth,
                    height: barHeight,
                    textAlign: textAlign,
                    fontOptions: fontOptions,
                    fontSize: fontSize,
                    displayValue: displayValue,
                    background: "#ffffff",
                    lineColor: "#000000"
                });
            } catch (e) {
                div.innerHTML = value;
            }
        });

    });

    window.applyBarcodeSearch(barcodesTable);
    window.clearBarcodeSearch(barcodesTable);


    var accessKeysTable = $('#access-keys').DataTable({
        "dom": "lrtip",
        "paging": true,
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [],
        "columnDefs": [{
            "targets": 4,
            "orderable": false
        },
        {
            "targets": [1, 2, 3],
            "searchable": false
        }
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No records matches your search criteria",
            "emptyTable": "No access keys to preview"

        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }

    });

    window.ApplyAccessKeySearch(accessKeysTable);
    window.clearAccessKeySearch(accessKeysTable);


    let usersTable = $('#users').DataTable({
        "dom": "lrtip",
        "paging": true,
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [],
        "columnDefs": [{
            "targets": 6,
            "orderable": false
        },
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No data matches your search criteria",
            "emptyTable": "No users to preview"

        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }

    });
    window.applyuserSearch(usersTable);
    window.clearuserSearch(usersTable);



    let dataConnectionsTable = $('#data-connections').DataTable({
        "dom": "lrtip",
        "paging": true,
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [],
        "columnDefs": [{
            "targets": 5,
            "orderable": false
        },
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No records matches your search criteria",
            "emptyTable": "No data connections to preview"

        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }

    });

    window.applyDataConnectionSearch(dataConnectionsTable);
    window.clearDataConnectionSearch(dataConnectionsTable);

    let scheduledReportsTable = $('#scheduled-reports').DataTable({
        "dom": "lrtip",
        "paging": true,
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [],
        "columnDefs": [{
            "targets": 5,
            "orderable": false
        },
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No records matches your search criteria",
            "emptyTable": "No scheduled reports to preview"
        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }

    });

    window.applyScheduledReportsSearch(scheduledReportsTable);
    window.clearScheduledReportsSearch(scheduledReportsTable);



    let accessLogsTable = $('#access-logs').DataTable({
        "dom": "lrtip",
        "paging": true,
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [],
        "columnDefs": [{
            "targets": 4,
            "orderable": false
        },
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No records matches your search criteria",
            "emptyTable": "No access logs to preview"
        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }

    });

    window.applyAccessLogsSearch(accessLogsTable);
    window.clearAccessLogsSearch(accessLogsTable);



    let DashboardsTable = $('#dashboards').DataTable({
        "dom": "lrtip",
        "paging": true,
        "pageLength": 10,
        "lengthChange": false,
        "searching": true,
        "ordering": true,
        "order": [],
        "columnDefs": [{
            "targets": 4,
            "orderable": false
        },
        ],
        "info": true,
        "autoWidth": false,
        "responsive": true,
        "language": {
            "zeroRecords": "No records matches your search criteria",
            "emptyTable": "No dashboards stored for this user account"

        },
        drawCallback: function (settings) {
            var pagination = $(this).closest('.dataTables_wrapper').find('.dataTables_paginate');
            pagination.toggle(this.api().page.info().pages > 1);
        }


    });


    window.applyDashboardsSearch(DashboardsTable);
    window.clearDashboardsSearch(DashboardsTable);





});


