$(function () {

    $('.container-fluid').on('click', "#add-chart-button", function () {

        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            beforeSend: function () {
                $('#add-chart-modal').modal('show');
            },
            success: function (response) {
                $("#add-chart-iframe-loader").fadeOut();
                $('#add-chart-modal').find("iframe").attr("src", url);

                $("#add-chart-modal-iframe").on('load', function () {

                    adjustModalHeight("add-chart-modal-iframe");

                    $("#add-chart-iframe-loader").fadeOut();
                });

            }, error: function (response) {
                $(`#success-modal`).find('h5').text(response.responseJSON.message).show();
                $(`#success-modal`).modal('show');
                $("#global-loader").fadeOut();
                $('#add-chart-modal').find("iframe").attr("src", "");

            }

        });

    });

    $("#add-chart-modal").on('hidden.bs.modal', function () {
        let forgetSessionUrl = $("#add-chart-button").data('forget');
        $.ajax({
            type: "POST",
            url: forgetSessionUrl,
            success: function () {
                $('#add-chart-modal').find("iframe").attr("src", "");
            }

        });

    })


    // change report category

    $(document).on('click', ".change-category", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            beforeSend: function () {
                $("#global-loader").fadeIn();
            },

            success: function (response) {
                $("#global-loader").fadeOut();

                $('#change-category-modal-container').html(response);
                $('#change-category-modal').modal('show');

                $("#change-category-modal").on("click", "#saveBtn-change-category", function () {

                    let fields = ["chart_category"];
                    sendAjaxRequest("change-category-form", fields, "confirm-change-category", "error-change-category", reloadChartPagePartially, [".chart-parent-container", ".chart-parent-container"], true);
                });

                $("#change-category-modal").on("click", "#cancelBtn-change-category", function () {
                    reloadForm("change-category-form");
                    $('#error-change-category, #confirm-change-category').hide();

                });


            },
        });

    });


    // delete report modal
    $(document).on('click', ".delete-chart", function (event) {
        let chart = $(this).closest('.card-header').find('h3').text();
        $('#delete-chart-modal').find('.modal-body p').text(`Are you sure you want to delete "${chart}" chart?`)
        $('#delete-chart-form').attr('data-url', $(this).attr('data-url'))
    });

    $("#delete-chart-form").on("click", "#saveBtn-delete-chart", function () {
        sendAjaxRequestWithSuccess("delete-chart-form", 'delete-chart-modal', reloadChartPagePartially, [".chart-parent-container", ".chart-parent-container"], true);

    });


    $(document).on('click', ".edit-chart", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            beforeSend: function () {
                $('#edit-chart-modal').modal('show');

                $("#edit-chart-iframe-loader").fadeIn();


            },
            success: function (response) {

                $('#edit-chart-modal').find("iframe").attr("src", url);

                $("#edit-chart-iframe-loader").fadeOut();

                $("#edit-chart-modal-iframe").on('load', function () {
                    $("#edit-chart-iframe-loader").fadeOut();

                    adjustModalHeight("edit-chart-modal-iframe");

                });

                $('#edit-chart-modal').on('hidden.bs.modal', function () {
                    let forgetSessionUrl = $("#add-chart-button").data('forget');

                    $.ajax({
                        type: "GET",
                        url: forgetSessionUrl,
                        success: function () {
                            $('#edit-chart-modal-iframe').attr("src", "");
                        }

                    });


                });
                $("#global-loader").fadeOut();


            }, error: function (response) {
                $(`#success-modal`).find('h5').text(response.responseJSON.message).show();
                $(`#success-modal`).modal('show');

                setTimeout(function () {
                    $('#edit-chart-modal').modal('hide');
                }, 500)

                $("#global-loader").fadeOut();


            }

        });

    });

    $(document).on('click', "#chart-search", function (e) {
        e.preventDefault();
        reloadPageWithSearch("chart-search-form", ".chart-parent-container", ".chart-parent-container");


    });

    $(document).on('click', ".show-all", function (e) {
        e.preventDefault();
        $('input[name="chartName"]').val("");
        $('input[name="chartTitle"]').val("");
        $('select[name="chartType"]').val("");
        reloadPageWithSearch("chart-search-form", ".chart-parent-container", ".chart-parent-container");

        let url = window.location.href.split("?")[0];
        // remove page query if exists
        window.history.replaceState('', '', url);
    });


    $(document).on('click', ".duplicate-chart", function () {
        let url = $(this).data('url');
        $('#duplicate-modal').modal('show');
        $('#duplicate-form').attr('data-url', $(this).attr('data-url'))
        $('#duplicate-form #name').val($(this).attr('data-name') + "_1")

    });


    $(document).on("click", "#saveBtn-duplicate", function () {
        
        sendAjaxRequestWithErrorsAndWithSuccess("duplicate-form", 'duplicate-modal','error-duplicate', reloadChartPagePartially, [".chart-parent-container", ".chart-parent-container"], true);

    });


})
