$(document).ready(function () {


    $(".container").on("click", ".add-barcode-button", function () {
        reloadForm("add-barcode-form");
    });

    $("#delete-barcode-form").on("click", "#saveBtn-delete-barcode", function () {

        sendAjaxRequestWithSuccess("delete-barcode-form", 'delete-barcode-modal', reloadBarcodeTable, ["barcodes"]);

    });


    // delete category modal
    $('#barcodes').on('click', ".delete-barcode", function (event) {
        let barcode = $(this).closest('tr').find('td:first').text();
        $('#delete-barcode-modal').find('.modal-body p').text(`Are you sure you want to delete this barcode definition? `)
        $('#delete-barcode-form').attr('data-url', $(this).attr('data-url'))
    });

    // delete category confirmation
    $('.delete-barcode').on('click', function (event) {
        $('#delete-barcode-form').attr('action', $(this).attr('data-url'))
    });


    // add category
    $("#add-barcode-form").on("click", "#saveBtn-add-barcode", function () {

        let fields = ["label", "type", "width", "height", "font_size", "text_align", "display_value"];
        sendAjaxRequest("add-barcode-form", fields, "add-barcode-confirm", "add-barcode-error", reloadBarcodeTable, ["barcodes", "add"]);

        $('#add-barcode-modal').on('hidden.bs.modal', function () {
            reloadForm("add-barcode-form");
        });

    });

    $("#add-barcode-form").on("click", "#cancelBtn-add-barcode", function () {
        reloadForm("add-barcode-form");
    });


    $('#barcodes').on('click', ".edit-barcode", function () {
        let url = $(this).data('url');

        $.ajax({
            type: "GET",
            url: url,
            success: function (response) {
                $('#edit-barcode-modal-container').html(response);
                $('#edit-barcode-modal').modal('show');

                $('[data-toggle="tooltip"]').tooltip();

                $("#edit-barcode-form").on("click", "#saveBtn-edit-barcode", function () {

                    let fields = ["name", "description", "icon"];
                    sendAjaxRequest("edit-barcode-form", fields, "edit-barcode-confirm", "edit-barcode-error", reloadBarcodeTable, ["barcodes"]);
                });

                $("#edit-barcode-form").on("click", "#cancelBtn-edit-barcode", function () {
                    reloadForm("edit-barcode-form");
                });


            },
        });

    });


});
