$(document).ready(function () {

    $('.security_inputs').hide();
    $('#error').hide();
    $('#success').hide();

    $('#checkEmail').on('click', function () {
        checkEmailValid();
    });

    $('#resetpassword').on('click', function () {
        resetPassword();
    });

    $('#register').on('click', function () {
        register();
    });


});




function checkEmailValid() {

    let form = document.getElementById("checkemailform");
    let checkMailUrl = $('#checkemailform').attr('data-check');

    $.ajax({
        type: "POST",
        url: checkMailUrl,
        data: new FormData(form),
        contentType: false,
        processData: false,
        success: function (response) {
            $('#question').val(response.data.security_question)
            $('.security_inputs').show();
            $('#checkEmail').off('click');
            $('#checkEmail').attr("id", "resetpassword")
            $('#error').hide();
            $('#checkemailform').attr("id", "resetpasswordform");

            $('#resetpassword').on('click', function () {
                resetPassword();
            });
            $("input[name=token]").val(response.token);
        },
        error: function (response) {
            $('#error').text(response.responseJSON.errors.email[0]).show();
            shakeModal();

        }
    });

}


function resetPassword() {

    var resetform = document.getElementById("resetpasswordform");
    let resetPasswordUrl = $('#resetpasswordform').attr('data-reset');

    $.ajax({
        type: "POST",
        url: resetPasswordUrl,
        data: new FormData(resetform),
        contentType: false,
        processData: false,
        dataType: "json",
        success: function (response) {


            if (response.message) {
                $('#success').text(response.message).show();
                $('#error').hide();
                $('.form').slideUp();

            }
            if (response.demo) {
                $(`#demo-modal`).find('h5').text(response.demo).show();
                $(`#demo-modal`).modal('show');
            }

        },
        error: function (response) {

            response = response.responseJSON;
            if (response.errors.email)
                $('#error').text(response.errors.email[0]).show();

            if (response.errors.security_answer)
                $('#error').text(response.errors.security_answer[0]).show();

            $('#success').hide();

            shakeModal();

        }
    });

}


function register() {

    var registerform = document.getElementById("registerform");
    let registerUrl = $('#registerform').attr('data-register');
    let fields = ["first_name", "last_name", "user_name", "email", "password", "password_confirmation", "Security_question_index", "Security_answer"];

    $.ajax({
        type: "POST",
        url: registerUrl,
        data: new FormData(registerform),
        contentType: false,
        processData: false,
        dataType: "json",
        success: function (response) {
            if (response.message) {

                $('#success').text(response.message).show();
                $('#error').hide();
                $('.form').slideUp();
            }

            if (response.demo) {
                $(`#demo-modal`).find('h5').text(response.demo).show();
                $(`#demo-modal`).modal('show');
            }





        },
        error: function (response) {

            response = response.responseJSON;
            // if (response.message) {
            //     $('#error').text(response.message.substring(0, response.message.lastIndexOf('.') + 1)).show();
            // }

            // if (response.errors.email) {
            //     $('#error').text(response.errors.email[0]).show();
            // }


            if (response.errors) {
                fields.every(error => {
                    if (response.errors[error]) {

                        $(`#error`).text(response.errors[error][0]).show();

                        $(`#success`).hide();

                        return false;
                    }
                    return true;

                });

            }


            $('#success').hide();

            shakeModal();

        }
    });

}



function shakeModal() {
    $('#loginModal .modal-dialog').addClass('shake');
    $('.error').addClass('alert alert-danger').html("Invalid email/password combination");
    $('input[type="password"]').val('');
    setTimeout(function () {
        $('#loginModal .modal-dialog').removeClass('shake');
    }, 1000);
}

$('#loginModal').modal({ backdrop: 'static', keyboard: false });
$('#forgetModal').modal({ backdrop: 'static', keyboard: false });
$('#confirmationModal').modal({ backdrop: 'static', keyboard: false });
