<?php

namespace App\Services;

use App\Models\Module;
use App\Models\Resource;
use App\Models\Dashboard;
use App\Services\ReportService;

class ResourceService
{
    public $reportService;
    public function __construct(ReportService $reportService)
    {
        $this->reportService = $reportService;
    }

    public function getAllResources()
    {
        return $this->reportService->getAllReports();
    }

    public function getAllResourceByModuleId($moduleId, $dashboard = null)
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");

        if ($dashboard && strtolower(Dashboard::find($dashboard)->access_type) == 'public') {
            return Resource::where(function ($q) use ($prefix, $moduleId) {
                $q->where(function ($q) use ($moduleId) {
                    $q->whereHas('module', function ($q) use ($moduleId) {
                        return $q->where('id', $moduleId);
                    })->orWhereHas('module.parent', function ($q) use ($moduleId) {
                        return $q->where('id', $moduleId);
                    });
                })->where(function ($q) use ($prefix) {
                    $q->where('access_control_type', 'Public');
                });
            })
                ->orderByDesc('created_at');
        }

        if (auth()->user()->isAdminOrOwner()) {
            return Resource::where(function ($q) use ($moduleId) {
                $q->where(function ($q) use ($moduleId) {
                    $q->whereHas('module', function ($q) use ($moduleId) {
                        return $q->where('id', $moduleId);
                    })->orWhereHas('module.parent', function ($q) use ($moduleId) {
                        return $q->where('id', $moduleId);
                    });
                });
            })
                ->orderByDesc('created_at');

        }

        return Resource::where(function ($q) use ($prefix, $moduleId) {
            $q->where(function ($q) use ($moduleId) {
                $q->whereHas('module', function ($q) use ($moduleId) {
                    return $q->where('id', $moduleId);
                })->orWhereHas('module.parent', function ($q) use ($moduleId) {
                    return $q->where('id', $moduleId);
                });
            })->where(function ($q) use ($prefix) {
                $q->whereHas('resource_permissions', function ($q) use ($prefix) {
                    return $q->where($prefix . 'resource_permissions.group_id', auth()->user()->group_id);
                })->orWhere(function ($q) {
                    $q->where('access_control_type', 'Public');
                })->orWhere('resource_creator', auth()->id());
            });
        })
            ->orderByDesc('created_at');
    }

    public function getAllEmbedResourcesByModuleId($moduleId, $dashboard = null)
    {
        $prefix   = config("srm_config.installer.table_prefix", "srm_");
        $isReport = Module::find($moduleId)->name == "Blank Reports";

        if ($dashboard && strtolower(Dashboard::find($dashboard)->access_type) == 'public') {
            return Resource::where(function ($q) use ($prefix, $moduleId) {
                $q->where(function ($q) use ($moduleId) {
                    $q->whereHas('module', function ($q) use ($moduleId) {
                        return $q->where('id', $moduleId);
                    })->orWhereHas('module.parent', function ($q) use ($moduleId) {
                        return $q->where('id', $moduleId);
                    });
                })->where(function ($q) use ($prefix) {
                    $q->where('access_control_type', 'Public');
                });
            })
                ->orderByDesc('created_at');
        }

        if (auth()->user()->isAdminOrOwner()) {
            return Resource::where(function ($q) use ($moduleId, $isReport) {
                $q->where(function ($q) use ($moduleId) {
                    $q->whereHas('module', function ($q) use ($moduleId) {
                        return $q->where('id', $moduleId);
                    })->orWhereHas('module.parent', function ($q) use ($moduleId) {
                        return $q->where('id', $moduleId);
                    });
                })->where(function ($q) use ($isReport) {
                    if (!$isReport) {
                        return;
                    }

                    $q->whereHas('configurations', function ($q) {
                        $q->where("Json_configurations->embed", "true");
                    });
                });
            })
                ->orderByDesc('created_at');

        }

        return Resource::where(function ($q) use ($prefix, $moduleId, $isReport) {
            $q->where(function ($q) use ($moduleId) {
                $q->whereHas('module', function ($q) use ($moduleId) {
                    return $q->where('id', $moduleId);
                })->orWhereHas('module.parent', function ($q) use ($moduleId) {
                    return $q->where('id', $moduleId);
                });
            })->where(function ($q) use ($prefix) {
                $q->whereHas('resource_permissions', function ($q) use ($prefix) {
                    return $q->where($prefix . 'resource_permissions.group_id', auth()->user()->group_id);
                })->orWhere(function ($q) {
                    $q->where('access_control_type', 'Public');
                })->orWhere('resource_creator', auth()->id());
            })->where(function ($q) use ($isReport) {

                if (!$isReport) {
                    return;
                }

                $q->whereHas('configurations', function ($q) {
                    $q->where("Json_configurations->embed", "true");
                });
            });
        })
            ->orderByDesc('created_at');
    }

}
