<?php

namespace App\Services;

use ArrayIterator;
use MultipleIterator;
use Illuminate\Http\Request;

class InstallService
{

    public function getInstallUrl()
    {

        $this->createSymbolicLinks();

        $public_uri = explode("/index.php", request()->server->get("PHP_SELF"))[0];

        return $public_uri . "/srm_install/";
    }


    private function createSymbolicLinks()
    {
        $base_path = base_path('../');

        $files = ["srm_install", "modules", "dashboard/storage/app/public"];
        $names = ["srm_install", "srm_modules", "srm_storage"];

        $mi = new MultipleIterator();
        $mi->attachIterator(new ArrayIterator($files));
        $mi->attachIterator(new ArrayIterator($names));

        foreach ($mi as [$file, $name]) {
            createSymblicLink($base_path . $file, public_path($name), ucfirst($name));
        }
    }
}
