<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ResourceConfiguration extends Model
{
    use HasFactory;

    protected $primaryKey = 'ID';
    protected $connection = 'mysql';
    public $timestamps = false;


    protected $fillable = [
        'Resource_id',
        'Json_configurations',
        'chart_type',
        'relation',
        'parameters',
    ];
    protected $casts = [
        'Json_configurations' => 'array',
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}resource_configuration";
    }


}
