<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BarcodeDefinition extends Model
{
    use HasFactory;
    protected $primaryKey = 'id';
    protected $connection = 'mysql';

    protected $fillable = [
        'label',
        'type',
        'display_value',
        'font_size',
        'width',
        'height',
        'text_align'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix      = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}barcode_definitions";
    }

    public static function tableName()
    {
        return with(new static )->getTable();
    }


    public function barcode_usage()
    {
        $prefix      = config('srm_config.installer.table_prefix', 'srm_');
        return $this->belongsToMany(BarcodeDefinition::class,$prefix.'barcode_usage');
    }
}
