<?php

namespace App\Models;

use App\Models\Group;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class AccessKey extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $primaryKey = 'id';
    protected $connection = 'mysql';

    protected $fillable = [
        'label',
        'access_key',
        'type',
        'group_id',
        'origin_type',
        'allowed_origins',
        'uses_count'
    ];

    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);
        $prefix      = config('srm_config.installer.table_prefix', 'srm_');
        $this->table = "{$prefix}access_keys";
    }

    public static function tableName()
    {
        return with(new static())->getTable();
    }


    public function group()
    {
        return $this->belongsTo(Group::class, 'group_id');
    }


        public function tokens()
    {
        return $this->hasMany(EmbedToken::class, 'access_key_id');
    }

}
