<?php

namespace App\Mails\ScheduledTaskMail;

use App\Mails\MailTrait;
use App\Models\Resource;
use App\Mails\MailInterface;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Config;
use App\Exceptions\SystemErrorException;
use Illuminate\Validation\ValidationException;

class ScheduledReportMail implements MailInterface
{
    use MailTrait;

    public $task;
    public $report;
    private $receiver;
    private $body;
    private $subject;
    private $content;
    private $username;
    private $signature;
    private $headers;

    public function __construct($task, $report, $receiver, $body)
    {
        $this->task = $task;
        $this->report = $report;
        $this->receiver = $receiver;
        $this->body = $body;
    }


    /**
     * Sends the scheduled email with the report attached.
     *
     * This method attempts to send an email containing the report using the `SendScheduledMail` service.
     * If any error occurs during the sending process, it logs the error and throws an exception.
     *
     * @tag srm_schdular
     */
    public function send()
    {
        try {
            SendScheduledMail::mail(
                $this->receiver['email'],
                $this->task->subject,
                $this->body,
                $this->report
            );
        } catch(\Exception $e) {
            Log::error($e->getMessage());
            throw new \Exception($e->getMessage());
        }
    }

    /**
     * Sets the content of the email message.
     *
     * This method assigns the provided body content to the `content` property of the class.
     * It is used to prepare the content of the email before sending.
     *
     * @tag srm_schdular
     */
    public function setMessageContent()
    {
        $this->content = $this->body;
    }


}
