<?php

namespace App\Mails;

use App\Mails\SendMail;
use App\Mails\MailTrait;
use App\Mails\MailInterface;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Config;
use App\Exceptions\SystemErrorException;
use Illuminate\Validation\ValidationException;

class ResetPasswordManually implements MailInterface
{
    use MailTrait;

    public $user;
    private $subject;
    private $content;
    private $username;
    private $signature;
    private $headers;
    private $receiver;
    private $temp_password;
    public function __construct($user, $temp_password)
    {
        $this->user = $user;
        $this->temp_password = $temp_password;
    }

    public function send()
    {
        $this->buildMailMessage("Your Smart Report Maker Password Has Been Reset");

        SendMail::mail(
            $this->receiver,
            $this->subject,
            $this->content,
            $this->headers,
        );
    }

    /**
     * Set the value of content
     */
    public function setMessageContent()
    {
        $username = $this->username;
        $password = $this->temp_password;
        $login = route('login');
        $signature = $this->signature;


        $this->content = view(
            'auth.mails.reset-password-manually',
            compact('username', 'password', 'login', 'signature')
        )->render();
    }
}
