<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class generateEmbedResourceRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            "resource_type"  => ["required"],
            "resources"         => ["required"],
            "access_key"         => [function($attribute, $value, $fail) {
                if ($value == null) {
                    $fail(trans("embed-resources.validations.required.access_key"));
                }
            }],
            "type_of_embed"         => ["required"],
        ];
    }

    public function messages()
    {
        return [
            "resource_type.required"       => trans("embed-resources.validations.required.resource_type"),
            "resources.required"       => trans("embed-resources.validations.required.resources"),
            "access_key.required"       => trans("embed-resources.validations.required.access_key"),
            "type_of_embed.required"       => trans("embed-resources.validations.required.type_of_embed"),

        ];
    }

}
