<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdatePivotTableCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");
        return [
            "pivot_table_category" => [
                "required", "exists:{$prefix}categories,id",

                function ($attribute, $value, $fail) {
                    if (
                        $value == $this->route('pivotTable')->category_id
                    ) {
                        $fail('Please select a new category for this report');
                    }
                }
            ]
        ];
    }
}
