<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateChartCategoryRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");
        return [
            "chart_category" => [
                "required", "exists:{$prefix}categories,id",

                function ($attribute, $value, $fail) {
                    if (
                        $value == $this->route('chart')->category_id
                    ) {
                        $fail(trans('charts.messages.select new category'));
                    }
                }
            ]
        ];
    }
}
