<?php

namespace App\Http\Requests;

use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class UpdateBarCodeDefinitionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");
        return [
            'label' => ["required", "max:100", Rule::unique("{$prefix}barcode_definitions", 'label')
                ->ignore($this->route('barcode')->id, 'id')],
            "type" => ["required", "max:50"],
            "display_value" => ["nullable", "boolean"],
            "font_size" => ["nullable", "numeric"],
            "width" => ["nullable", "numeric"],
            "height" => ["nullable", "numeric"],
            "text_align" => ["nullable", "in:left,center,right"],

        ];
    }

    public function prepareForValidation()
{
    $this->merge([
        'display_value' => $this->has('display_value') ? $this->boolean('display_value') : 0,
    ]);
}

    public function messages()
    {
        return [
            "label.required" => "Please enter a Label.",
            "type.required" => "Please select barcode type."
        ];
    }
}
