<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DuplicateReportRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");

        return [
            'name' => ['required', "unique:{$prefix}analytics_resources,name", 'regex:/^[a-zA-Z_][a-zA-Z0-9_ \-]*$/']
        ];
    }

    public function messages()
    {
        return [
            'name.required' => trans('pivot-tables.validations.required.values_fields')
        ];
    }
}
