<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ActivateUserRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $prefix = config("srm_config.installer.table_prefix", "srm_");

        return [
            'user-group' => ['required', 'numeric', "exists:{$prefix}Group,group_ID"]
        ];
    }

    public function messages()
    {
        return [
            'user-group.required' => 'Please select a group to activate this user',
            'user-group.numeric' => 'Please select a group to activate this user',
            'user-group.exists' => 'Please select a group to activate this user',
        ];
    }
}
