<?php

namespace App\Http\Middleware;

use App\Exceptions\ExpiredSignatureException;
use Closure;
use App\Exceptions\InvalidSignatureException;
use Illuminate\Routing\Middleware\ValidateSignature as MiddlewareValidateSignature;

class ValidateSignature extends MiddlewareValidateSignature
{
    /**
     * The names of the query string parameters that should be ignored.
     *
     * @var array<int, string>
     */
    protected $except = [
        'xValue',
        'export',
        'page'
    ];

    public function handle($request, Closure $next, ...$args)
    {
        if(auth()->user()){
            return $next($request);
        }

        [$relative, $ignore] = $this->parseArguments($args);

        if ($request->hasValidSignatureWhileIgnoring($ignore, !$relative)) {
            return $next($request);
        }

        if ($this->signatureHasExpired($request)) {
            throw new ExpiredSignatureException;
        }

        throw new InvalidSignatureException;
    }

    protected function signatureHasExpired($request)
    {
        $expires = $request->query('expires');

        return $expires && now()->getTimestamp() > $expires;
    }

}
