<?php

namespace App\Http\Controllers\PivotTables;

use Barryvdh\DomPDF\Facade\Pdf;
use App\Builders\PivotTableBuilder;
use App\Services\PivotTableService;
use App\Http\Controllers\Controller;
use App\Http\Requests\PivotTable\PivotTableRequest;
use App\Models\Resource;
use Illuminate\Http\Request;

class PivotTableExportController extends Controller
{
    public $pivotTableService;

    public function __construct(PivotTableService $pivotTableService)
    {
        $this->pivotTableService = $pivotTableService;

    }

    public function createExport(PivotTableRequest $request)
    {
        $pivotTable = $this->pivotTableService->exportCreate($request->validated());

        $this->pivotTableService->buildCsv($pivotTable);
    }


    public function showExport(Request $request, Resource $pivotTable)
    {
        [$pivotTable, $request] = $this->pivotTableService->exportShow($pivotTable, $request);
        $this->pivotTableService->buildCsv($pivotTable);
    }
}
