<?php

namespace App\Http\Controllers\PivotTables;

use App\Services\PivotTableService;
use App\Http\Controllers\Controller;
use App\Http\Middleware\OnlyFullVersion;
use App\Http\Requests\PivotTable\PivotTableDuplicateRequest;
use App\Http\Requests\PivotTable\PivotTableRequest;
use App\Models\Resource;

class PivotTableDuplicateController extends Controller
{
    private $pivotTableService;

    public function __construct(PivotTableService $pivotTableService)
    {
        $this->pivotTableService = $pivotTableService;

        $this->middleware(OnlyFullVersion::class);

    }

    public function __invoke(PivotTableDuplicateRequest $request, Resource $pivotTable)
    {
        $resourceId = $this->pivotTableService->duplicate($request->validated(), $pivotTable);

        return response()->json([
            'success' => true,
            "message" => trans('pivot-tables.messages.duplicate'),
            "resource" => $resourceId
        ]);

    }

}
