<?php

namespace App\Http\Controllers;

use App\Services\BarcodeService;
use App\Models\BarcodeDefinition;
use App\Http\Middleware\OnlyFullVersion;
use App\Http\Requests\StoreBarCodeDefinitionRequest;
use App\Http\Requests\UpdateBarCodeDefinitionRequest;

class BarcodesDefinitionsController extends Controller
{
    public $barcodeService;

    public function __construct(BarcodeService $barcodeService)
    {
        $this->barcodeService = $barcodeService;

        $this->middleware(OnlyFullVersion::class)->only(
            [
                'store',
                'update',
                'destroy'
            ]
        );
    }

    public function index()
    {
        $barcodes = $this->barcodeService->index();

        return view('dashboard.barcodes.index', compact('barcodes'));
    }


    public function store(StoreBarCodeDefinitionRequest $request)
    {
        $this->barcodeService->store($request->validated());

        return response()->json([
            "message" => "New Barcode Definition saved successfully"
        ]);
    }

    public function edit(BarcodeDefinition $barcode)
    {
        return view('dashboard.barcodes.edit', compact('barcode'));
    }

    public function update(UpdateBarCodeDefinitionRequest $request, BarcodeDefinition $barcode)
    {

        $this->barcodeService->update($request->validated(), $barcode);
        return response()->json([
            "message" => "\"{$barcode->label}\" is edited successfully"
        ]);
    }


    public function destroy(BarcodeDefinition $barcode)
    {
        $this->barcodeService->destroy($barcode);

        return response()->json([
            'message' => 'This Barcode definition has been successfully deleted!'
        ]);
    }
}
