<?php

namespace App\Builders\Helpers;

class InterpolateDateFilter
{
    private $xAxis;
    private $yAxis;
    private $dateFilter;

    public function __construct($xAxis, $yAxis, $dateFilter)
    {
        $this->xAxis      = $xAxis;
        $this->yAxis      = $yAxis;
        $this->dateFilter = $dateFilter;
    }

    public function interploate()
    {

        if (empty($this->dateFilter)) {
            return [$this->xAxis, $this->yAxis];
        }

        $combinedNames = array_unique(array_merge($this->xAxis, $this->dateFilter));

        $combinedValues = [];

        foreach ($combinedNames as $combinedName) {

            if (in_array($combinedName, $this->xAxis)) {
                $index            = array_search($combinedName, $this->xAxis);
                $combinedValues[] = $this->yAxis[$index];
            } else {
                $combinedValues[] = 0;
            }

        }

        return [$combinedNames, $combinedValues];
    }

}