<?php

    use Webuccino\Install\Core\Session;

require base_path_native('views/partials/head.php')?>
<?php require base_path_native('views/partials/pills.php')?>
<link href="<?=asset_native('assets/assets/css/loader.css')?>" rel="stylesheet" />

<div id="loading-loader">
  <img src="<?=asset_native('assets/assets/img/loader.gif')?>" class="loader-img" alt="Loader">
  <div class="loader-text">Test SMTP Server please wait ..</div>
</div>

<div class="tab-content">
  <div class="row">
    <div class="col-sm-12">
      <div class="form-group">
        <label>SMTP Server</label>
        <p class="description">
          Smart Report Maker needs an SMTP server or an
          email service to be able to send emails.
        </p>
      </div>
    </div>
  </div>

  <form id="setting-form" method="POST" data-path="<?=route_native('/')?>" data-action="checkSmtp">
    <?php

    if (config_native('srm_config.installer.allow_smtp_later')): ?>
    <div class="row">
      <div class="col-sm-12 col-sm-offset-1">

        <div class="form-group">
          <input type="checkbox" name="allow_smtp_later" class="form-check-input" id="allow-smtp-later"
            <?=Session::get('allow-smtp-later') ? 'checked' : ''?>>
          <label for="allow-smtp-later" class="form-check-label">Add SMTP Server Later</label>
        </div>

      </div>
    </div>
    <?php endif?>

    <div id="smtp-container">

      <div class="row">
        <div class="col-sm-5 col-sm-offset-1">
          <div class="form-group">
            <label>SMTP Server</label>
            <input type="text" id="smtp_host" name="smtp_host" class="form-control" placeholder="Enter SMTP Server" />
          </div>
        </div>

        <div class="col-sm-5">
          <div class="form-group">
            <label>SMTP PORT</label>
            <input id="smtp_port" name="smtp_port" type="text" class="form-control username"
              placeholder="Enter SMTP PORT" />
          </div>
        </div>

      </div>

      <div class="row">

        <div class="col-sm-5 col-sm-offset-1">
          <div class="form-group">
            <label>User Name</label>
            <input type="text" id="smtp_username" name="smtp_username" class="form-control database"
              placeholder="Enter User Name" />
          </div>
        </div>

        <div class="col-sm-5">
          <div class="form-group">
            <label>Password</label>
            <input type="password" id="smtp_password" name="smtp_password" class="form-control username"
              placeholder="password" />
          </div>
        </div>

      </div>


      <div class="row">
        <div class="col-sm-5 col-sm-offset-1">
          <div class="form-group">
            <label>encryption</label>
            <select class="form-control" name="smtp_encryption" id="smtp_encryption">
              <option value="none" selected>None (No Encryption)</option>
              <option value="tls">TLS (Transport Layer Security)</option>
              <option value="ssl">SSL (Secure Sockets Layer)</option>
              <option value="tls">STARTTLS</option>
              <option value="auto">Auto (Automatic Detection)</option>
            </select>
          </div>
        </div>
        <div class="col-sm-5">
          <div class="form-group">
            <label>authentication mode</label>
            <select class="form-control" name="smtp_auth_mode" id="smtp_auth_mode">
              <option value="PLAIN" selected>PLAIN</option>
              <option value="LOGIN">LOGIN</option>
              <option value="CRAM-MD5">CRAM-MD5</option>
              <!-- Add more options as needed -->
            </select>
          </div>
        </div>
      </div>

      <div class="row">
        <div class="col-xs-12 text-center">
          <input type="submit" class="btn btn-fill btn-success btn-wd" name="test-smtp" value="Test SMTP Server" />
        </div>
        <div style="margin-top: 10px" class="msg text-center text-danger pt-2" data-toggle="tooltip"></div>

      </div>
    </div>
  </form>
  <form action="<?=route_native('/storeEmailSettings')?>" method="POST">

    <input type="hidden" name="allow_smtp_later_form" class="form-check-input" id="allow-smtp-later-form"
      <?=Session::get('allow-smtp-later') ? 'value="1"' : 'value="0"'?>>


    <div class="row">
      <div class="col-sm-12">
        <div class="form-group">
          <label>Scheduled Jobs</label>
          <p class="description">
            The settings of the scheduled jobs carried out by
            Smart Report Maker, such as sending periodic
            emails.
          </p>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-sm-5 col-sm-offset-1">
        <div class="form-group" id="schedulerInstruction">
          <label>Timezone</label>
          <span class="glyphicon glyphicon-info-sign" style="color: #68b3c8" data-toggle="tooltip"
            data-title="This time zone will be utilized throughout the system, particularly in any scheduled processes."></span>
          <select class="form-control timezone" id="timezone" name="timezone">
            <?php

            foreach (get_time_zones() as $identifier => $timezone): ?>
            <option value="<?php echo $identifier ?>">
              <?php echo $timezone ?>
            </option>
            <?php endforeach;?>
          </select>
        </div>
      </div>
      <div class="col-sm-5">
        <div class="form-group">
          <label>From Email</label>
          <span class="glyphicon glyphicon-info-sign" style="color: #68b3c8" data-toggle="tooltip" data-title='All emails sent from Smart Report Maker will have this email address as the "From" and "Reply To"
          address.'></span>
          <input type="email" class="form-control <?=(isset($errors['email'])) ? 'error' : ''?>" name="email" id="email"
            placeholder="Enter valid email" value="<?=old_native('email')?>" />
          <?php

          if (isset($errors['email'])): ?>
          <label id="email-error" class="error" data-toggle="tooltip" data-title='<?=$errors['email']?>'
            for="email"><?=substr($errors['email'], 0, 50) . '...'?> </label>
          <?php endif;?>

        </div>
      </div>
    </div>

    <div class="row">
      <div class="col-sm-5 col-sm-offset-1">
        <div class="form-group" id="schedulerInstruction">
          <label>From Name</label>
          <span class="glyphicon glyphicon-info-sign" style="color: #68b3c8" data-toggle="tooltip"
            data-title="Enter the display name or sender's name that you want to appear in the 'From' field of any email notification sent from the system to your users. This name provides a recognizable sender identity to your recipients. For example, you can use your company name or your personal name. It will be shown as '<From Name> <from email>' in the recipient's email client."></span>
          <input type="text" class="form-control <?=(isset($errors['name'])) ? 'error' : ''?>" name="name"
            placeholder="Enter From Name" value="<?=old_native('name')?>" />
          <?php

          if (isset($errors['name'])): ?>
          <label id="name-error" class="error" data-toggle="tooltip" data-title='<?=$errors['name']?>'
            for="name"><?=substr($errors['name'], 0, 50) . '...'?> </label>
          <?php endif;?>

        </div>
      </div>
      <div class="col-sm-5">
        <div class="form-group">
          <label>Default Mail signature</label>
          <span class="glyphicon glyphicon-info-sign" style="color: #68b3c8" data-toggle="tooltip"
            data-title='Enter the email signature text that you want to include at the end of all email notifications sent by the system. > Max length is 255 characters'></span>
          <textarea class="form-control <?=(isset($errors['mail-signature'])) ? 'error' : ''?>" name="mail-signature"
            id="mail-signature" placeholder="Enter Mail Signature"><?=old_native('mail-signature')?></textarea>
          <?php

          if (isset($errors['mail-signature'])): ?>
          <label id="mail-signature-error" class="error" data-toggle="tooltip"
            data-title='<?=$errors['mail-signature']?>'
            for="mail-signature"><?=substr($errors['mail-signature'], 0, 50) . '...'?> </label>
          <?php endif;?>

        </div>
      </div>
    </div>
    <?php

    if (false): ?>
    <div class="row">
      <div class="col-sm-12">
        <div class="form-group">
          <label>Cronjob</label>
          <p class="description">
            <i class="fa fa-clock-o" style="color: #f3bb45"></i>
            Kindly set up one cronjob to run each one minute and execute this PHP script. Smart Report Maker will use
            this setup to send periodic reports via email.
          </p>
          <ul>
            <li>The URL of the PHP script that needs to be executed by the cronjob:</li>

            <ul>

              <li>
                <code class="srm-code"><?php echo get_cron_job_script() ?></code>
              </li>
            </ul>
            <li>The command executed by the cronjob depends on the PHP executable path
              and other factors you should verify. Here's an example:</li>
            <ul>
              <li>
                <code
                  class="srm-code">* * * * *                                                                                                                                                                                         <?php echo get_cron_job_script(true, "php") ?></code>
              </li>
            </ul>
            <li>Note: To determine the path of PHP on your server, run the following
              command: <code class="text-black">which</code> php or the command
              <code class="text-black">whereis</code>
              php. If the path is something
              like <code class="text-black">/usr/bin/php</code>, then the cron job
              command should be adapted as
              follows:
            </li>
            <ul>
              <li>
                <code
                  class="srm-code">* * * * *                                                                                                                                                                                         <?php echo get_cron_job_script(true, "/usr/bin/php") ?></code>
              </li>
            </ul>
          </ul>
          <div class="form-check">
            <input class="form-check-input <?=(isset($errors['confirm-cronjob'])) ? 'error' : ''?>" type="checkbox"
              value="1" id="confirm-cronjob" name="confirm-cronjob" />
            <label for="confirm-cronjob" id="confirm-cronjob-label"> Cronjob created as needed. </label>
            <?php

            if (isset($errors["confirm-cronjob"])): ?>

          </div>
          <label id="confirm-cronjob-error" class="error" data-toggle="tooltip"
            data-title="<?=$errors['confirm-cronjob']?>" for="confirm-cronjob"><?=$errors['confirm-cronjob']?>
          </label>
          <?php endif;?>

        </div>
      </div>
    </div>
    <?php endif;?>
    <div style="margin: 20px" class="wizard-footer">
      <div class="pull-right">
        <!-- Finish Button -->
        <input type="submit" id="finish" class="btn btn-finish btn-fill btn-warning btn-wd" name="finish" value="Finish"
          data-disabled="<?=Session::has('smtp-connection-success') ? "enable" : "disable"?>" />
      </div>
      <div class="pull-left">
        <a class="btn btn-previous btn-default btn-wd" href="<?=route_native('/profile')?>">Previous</a>
      </div>
      <div class="clearfix"></div>
    </div>
  </form>
</div>
<?php require base_path_native('views/partials/confirm-smtp-modal.php')?>



<?php require base_path_native('views/partials/footer.php')?>