<?php

require base_path_native('views/partials/head.php')?>
<?php require base_path_native('views/partials/pills.php')?>

<div class="tab-content">
  <div class="row"></div>
  <div class="row">
    <div class="col-sm-12">
      <div class="form-group">
        <label>Admin Profile </label>
        <p style="margin: 20px" class="description">
          Use the following page to create an Admin account
          for Smart Report Maker. This account holds Owner
          privileges, which means it should have full
          permissions within the system. Additionally, it
          cannot be deleted from any screen within Smart
          Report Maker.
        </p>
      </div>
    </div>
  </div>
  <form id="profile-form" action="<?=route_native('/saveProfile')?>" method="POST" autocomplete="off">
    <div class="row">
      <ul class="profile_message"></ul>
      <div class="col-sm-5 col-sm-offset-1">
        <div class="form-group">
          <label>E-mail</label>
          <input type="email" class="form-control <?=(isset($errors['email'])) ? 'error' : ''?>" id="email"
            name="profile_email" placeholder="user@example.com" value="<?=old_native('email')?>" autocomplete="off" />
          <?php

          if (isset($errors['email'])): ?>
          <label id="email-error" class="error" data-toggle="tooltip" data-title="<?=$errors['email']?>"
            for="email"><?=$errors['email']?> </label>
          <?php endif;?>
        </div>
      </div>
      <div class="col-sm-5">
        <div class="form-group">
          <label>User Name</label>
          <input type="text" class="form-control <?=(isset($errors['username'])) ? 'error' : ''?>" id="username"
            name="profile_username" placeholder="Enter your user name you want" value="<?=old_native('username')?>"
            autocomplete="off" />
          <?php

          if (isset($errors['username'])): ?>
          <label id="username-error" class="error" data-toggle="tooltip" data-title="<?=$errors['username']?>"
            for="username"><?=$errors['username']?> </label>
          <?php endif;?>
        </div>
      </div>
    </div>
    <div class="row">
      <div class="col-sm-5 col-sm-offset-1">
        <div class="form-group">
          <label>Password</label>
          <input type="password" class="form-control <?=(isset($errors['password'])) ? 'error' : ''?>" id="password"
            name="profile_password" placeholder="Enter password here" autocomplete="off" />
          <?php

          if (isset($errors['password'])): ?>
          <label id="password-error" class="error" data-toggle="tooltip" data-title="<?=$errors['password']?>"
            for="password"><?=substr($errors['password'], 0, 50) . '...'?> </label>
          <?php endif;?>

        </div>
      </div>
      <div class="col-sm-5">
        <div class="form-group">
          <label>Confirm Password</label>
          <input type="password" class="form-control <?=(isset($errors['confirmpassword'])) ? 'error' : ''?>"
            id="confirmpassword" name="confirmpassword" placeholder="Re-write the same password" autocomplete="off" />
          <?php

          if (isset($errors['confirmpassword'])): ?>
          <label id="confirmpassword-error" class="error" data-toggle="tooltip"
            data-title="<?=$errors['confirmpassword']?>" for="confirmpassword"><?=$errors['confirmpassword']?>
          </label>
          <?php endif;?>

        </div>
      </div>
    </div>
    <!-- Timezone hidden input -->
    <!-- <input id="timezone" name="timezone" hidden> -->
    <div class="row">
      <div class="col-sm-5 col-sm-offset-1">
        <div class="form-group">
          <label>Security Question</label>
          <select class="form-control  <?=(isset($errors['security_question'])) ? 'error' : ''?>"
            name="security_question" id="security_question">
            <?php

            foreach (config_native('srm_config.dashboard.security_questions') as $index => $question): ?>
            <option value="<?=$index?>" <?=$index == old_native('security_question') ? 'selected' : ''?>>
              <?=$question?>
            </option>
            <?php endforeach?>
          </select>
          <?php

          if (isset($errors['security_question'])): ?>
          <label id="security_question-error" class="error" data-toggle="tooltip"
            data-title="<?=$errors['security_question']?>" for="security_question"><?=$errors['security_question']?>
          </label>
          <?php endif;?>

          <!--<input type="text" class="form-control" name="security_question" placeholder="What is your security question you want?">-->
        </div>
      </div>

      <div class="col-sm-5">
        <div class="form-group">
          <label>Answer</label>
          <input type="text" class="form-control <?=(isset($errors['security_answer'])) ? 'error' : ''?>"
            id="security_answer" name="security_answer" placeholder="Answer of the security question"
            value="<?=old_native('security_answer')?>" autocomplete="off" />
          <?php

          if (isset($errors['security_answer'])): ?>
          <label id="security_answer-error" class="error" data-toggle="tooltip"
            data-title="<?=$errors['security_answer']?>" for="security_answer"><?=$errors['security_answer']?>
          </label>
          <?php endif;?>

        </div>
      </div>
    </div>
    <div style="margin: 20px" class="wizard-footer">
      <div class="pull-right">
        <!-- Finish Button -->
        <?php

        if (config_native('srm_config.installer.is_settings_step_needed')): ?>

        <input type="submit" class="btn btn-fill btn-warning btn-wd" name="next" value="Next" />

        <?php else: ?>

        <input type="submit" id="finish" class="btn btn-finish btn-fill btn-warning btn-wd" name="finish" value="Finish"
          data-disabled="<?=config_native("srm_config.installer.is_settings_step_needed") ? "disable" : "enable"?>" />

        <?php endif;?>
      </div>
      <div class="pull-left">
        <a class="btn btn-previous btn-default btn-wd" href="<?=route_native('/database')?>">Previous</a>
      </div>
      <div class="clearfix"></div>
    </div>
  </form>
</div>


<?php require base_path_native('views/partials/footer.php')?>