<?php require base_path_native('views/partials/head.php')?>
<?php require base_path_native('views/partials/pills.php')?>
<div class="tab-content">
  <div class="row">
    <div class="col-sm-12">
      <div class="form-group">
        <label>Directory Permissions</label>
        <p class="description">
          Please make sure to assign read/write permissions
          (755 for Linux servers) to the directories listed
          below. This step is essential because Smart Report
          Maker needs these permissions in order to generate
          configuration files within these directories.
        </p>
      </div>
    </div>
  </div>
  <?php

  if (Webuccino\Install\Core\Session::has('permission_error')): ?>
  <div class="text-center text-danger">
    <small>Error: <?=Webuccino\Install\Core\Session::get('permission_error')?></small>
  </div>
  <?php endif;?>
  <div style="margin: 25px" class="row">
    <?php

    foreach (check_write_permissions() as $directory): ?>
    <div class="col-xs-12" style="margin-bottom: 10px">
      <span style="font-size: 12px; padding: 5px"><i class="fa fa-folder" aria-hidden="true"></i>
        <?=$directory?></span>
    </div>
    <?php endforeach;?>

  </div>

  <?php

  if (!check_minimum_php_version()["can_run"]): ?>
  <div class="text-center text-danger text-sm">
    <small><?=check_minimum_php_version()["php_version_warning"]?></small>
  </div>
  <?php endif;?>

  <div style="margin: 20px" class="wizard-footer">
    <div class="pull-right">
      <!-- Finish Button -->
      <form action="<?=route_native('/permissions')?>" method="POST">
        <input type="submit" class="btn btn-fill btn-warning btn-wd" value="Next" />
      </form>
    </div>
    <div class="pull-left">
      <a class="btn btn-previous btn-default btn-wd" href="<?=route_native('/')?>">Previous</a>
    </div>
    <div class="clearfix"></div>
  </div>

</div>

<?php require base_path_native('views/partials/footer.php')?>