<?php

namespace Webuccino\Install\seeder;

use DateTime;
use App\Models\ResourcePermission;
use Exception;
use Illuminate\Database\Capsule\Manager as Capsule;

class TestingDataSeeder
{
    public $table;
    public $prefix;
    public function __construct()
    {
        $this->prefix = config_native('srm_config.installer.table_prefix');

        $this->table = $this->prefix . 'Settings';
        $this->categories = $this->prefix . 'categories';
        $this->groups = $this->prefix . 'Group';
        $this->dataconnections = $this->prefix . 'dataconnections';
        $this->users = $this->prefix . 'Users';
        $this->resources = $this->prefix . 'analytics_resources';
        $this->modules = $this->prefix . 'modules';
        $this->resourcePermissions = $this->prefix . 'resource_permissions';
    }

    public function run()
    {
        $salesCatoegory = $this->addCategory("Sales")->id;
        $supportCategory = $this->addCategory("Support")->id;
        $AdminCategory = $this->addCategory("Admins")->id;

        $salesGroup = $this->addGroup(1, "Sales")->group_ID;
        $supportGroup = $this->addGroup(2, "Support")->group_ID;
        $BlankReport = $this->getModuleId("Blank Reports");

        $northwind_connection = $this->addDataConnection(
            "northwind_connection",
            "webuccino.co",
            "srm_test_database",
            "srm_test_database_user",
            "p@ssword"
        )->id;

        $eman = $this->addUser("dr.emy285@gmail.com", "Eman", "111Admin", null, 1)->user_ID;
        $ahmed = $this->addUser("ahmedhamada015@gmail.com", "Ahmed", "111Admin", 1)->user_ID;
        $karim_sales = $this->addUser("akarim@mysqlreports.com", "A.karim.sales", "111Admin", 1)->user_ID;
        $karim_support = $this->addUser("engakarim@gmail.com", "A.karim.support", "111Admin", 2)->user_ID;

        $this->addResource(
            1,
            "Sales per country",
            $salesCatoegory,
            $eman,
            "Private",
            "SRM9/SRM/Reports9/repSalesPercountry/repSalesPercountry.php",
            $BlankReport,
            $northwind_connection,
            $salesGroup
        );

        $this->addResource(
            2,
            "Sales Per items",
            $salesCatoegory,
            $ahmed,
            "Private",
            "SRM9/SRM/Reports9/repSalesperitems/repSalesperitems.php",
            $BlankReport,
            $northwind_connection,
            $salesGroup
        );

        $this->addResource(
            3,
            "Customers details Per country",
            $supportCategory,
            $eman,
            "Private",
            "SRM9/SRM/Reports9/repCustomersdetailsPercountry/repCustomersdetailsPercountry.php",
            $BlankReport,
            $northwind_connection,
            $supportGroup
        );

        $this->addResource(
            4,
            "Customers data",
            $supportCategory,
            $karim_support,
            "Private",
            "SRM9/SRM/Reports9/repCustomersdata/repCustomersdata.php",
            $BlankReport,
            $northwind_connection,
            $supportGroup
        );

        $this->addResource(
            5,
            "items public",
            $salesCatoegory,
            $ahmed,
            "Public",
            "SRM9/SRM/Reports9/repitemspublic/repitemspublic.php",
            $BlankReport,
            $northwind_connection,
        );

        $this->addResource(
            6,
            "users",
            $AdminCategory,
            $eman,
            "Private",
            "SRM9/SRM/Reports9/repusers/repusers.php",
            $BlankReport,
            $northwind_connection,
            null,
            true
        );
    }

    private function addCategory($category)
    {
        Capsule::table($this->categories)->updateOrInsert(
            ["name" => $category],
            [
            "icon" => "#xf0a8;",
            "created_at" => (new DateTime())->format('Y-m-d H:i:s'),
        ],
        );

        return Capsule::table($this->categories)->where("name", $category)->first();
    }


    private function addGroup($id, $name)
    {
        Capsule::table($this->groups)->updateOrInsert(
            ["name" => $name],
            [
            "group_ID" => $id,
            "created_at" => (new DateTime())->format('Y-m-d H:i:s'),
        ],
        );

        return Capsule::table($this->groups)->where("name", $name)->first();
    }

    private function addDataConnection($name, $server, $dbname, $username, $password)
    {
        Capsule::table($this->dataconnections)->updateOrInsert(
            [
                "connection_name" => $name,
            ],
            [
            "db_type" => 'MYSQL',
            "server" => $server,
            "db" => $dbname,
            "connection_string" => encrypt_native($this->buildConnectionString($username, $password)),
            "created_at" => (new DateTime())->format('Y-m-d H:i:s'),

        ],
        );

        return Capsule::table($this->dataconnections)->where("connection_name", $name)->first();
    }

    private function buildConnectionString($username, $password, $charset = null, $collation = null, $port = "3306")
    {
        $port = isset($port) ? $port : "3306";
        $charset = isset($charset) ? $charset : "utf8mb4";
        $collation = isset($collation) ? $collation : "utf8mb4_unicode_ci";

        return sprintf(
            'user=%s;password=%s;charset=%s;collation=%s;port=%s',
            $username,
            $password,
            $charset,
            $collation,
            $port,
        );
    }

    private function addUser($email, $username, $password, $group_id = null, $is_admin = 0)
    {
        Capsule::table($this->users)->updateOrInsert(
            [
                "Email" => $email,
                "user_name" => $username
            ],
            [
            "user_name" => $username,
            "Password" => password_hash($password, PASSWORD_BCRYPT),
            "group_id" => $group_id,
            "is_admin" => $is_admin,
            "consecutive_login_failures" => 0,
            'status' => "Active",
            'email_verified_at' => (new DateTime())->format('Y-m-d H:i:s'),
            'created_at' => (new DateTime())->format('Y-m-d H:i:s'),

        ],
        );

        return Capsule::table($this->users)->where("Email", $email)->first();
    }

    private function addResource($id, $name, $categoryId, $resourceCreator, $securityType, $url, $moduleId, $dataConnectionId, $groupId = null, $onlyAdmin = null)
    {
        $resource = Capsule::table($this->resources)->updateOrInsert(
            ["name" => $name],
            [
            "id" => $id,
            "category_id" => $categoryId,
            "resource_creator" => $resourceCreator,
            "access_control_type" => $securityType,
            "url" => $url,
            "module_id" => $moduleId,
            "data_connection_id" => $dataConnectionId,
            "created_at" => (new DateTime())->format('Y-m-d H:i:s')
        ],
        );

        $resource = Capsule::table($this->resources)->where("name", $name)->first();

        if ($securityType === "Private" && !$onlyAdmin) {
            Capsule::table($this->resourcePermissions)->updateOrInsert(
                ['group_id' => $groupId,
                'resource_id' => $resource->id
            ],
                [
                'can_view' => true,
            ]
            );
        }

        return $resource;

    }

    private function getModuleId($module)
    {
        return Capsule::table($this->modules)
            ->where('name', $module)
            ->first()->id;
    }
}
