<?php

namespace Webuccino\Install\seeder;

use Illuminate\Database\Capsule\Manager as Capsule;

class SettingsSeeder
{
    public $table;
    public $prefix;
    public function __construct()
    {
        $this->prefix = config_native('srm_config.installer.table_prefix');

        $this->table = $this->prefix . 'Settings';
    }

    public function run()
    {

        Capsule::table($this->table)->updateOrInsert(
            ['settings_key' => "system_logo"],
            [
            'settings_value' => 'dist/images/srm-logo.jpg'
      ]
        );

        Capsule::table($this->table)->updateOrInsert(
            ['settings_key' => "mail_retry_count"],
            ['settings_value' => '3']
        );

        Capsule::table($this->table)->updateOrInsert(
            ['settings_key' => "mail_retry_interval_min"],
            ['settings_value' => '10']
        );

        Capsule::table($this->table)->updateOrInsert(
            ['settings_key' => "scheduling_cron_job_interval"],
            ['settings_value' => 15]
        );

        Capsule::table($this->table)->updateOrInsert(
            ['settings_key' => "log_sending_batch_reports_task"],
            ['settings_value' => true]
        );

        Capsule::table($this->table)->updateOrInsert(
            ['settings_key' => "pdf_attachments"],
            ['settings_value' => 'config/pdfs/']
        );

        Capsule::table($this->table)->updateOrInsert(
            ['settings_key' => "shared_key"],
            ['settings_value' => encrypt_native(base64_encode(random_bytes(256)))]
        );


    }
}