<?php

namespace Webuccino\Install\seeder;

use Illuminate\Database\Capsule\Manager as Capsule;

class ModulesSeeder
{
    public $table;
    public $prefix;
    public function __construct()
    {
        $this->prefix = config_native('srm_config.installer.table_prefix');

        $this->table = $this->prefix . 'modules';
    }

    public function run()
    {

        Capsule::table($this->table)->updateOrInsert(
            ['name' => 'Reports'],
            [

            'logo' => '<i class="fa fa-file" aria-hidden="true"></i></i>',
            'is_active' => true,
            'description' => 'You have the option to generate reports from your database: either create a new report from scratch using the wizard report builder or utilize pre-designed templates.',
            'parent_id' => null,
      ],
        );

        Capsule::table($this->table)->updateOrInsert(
            ['name' => 'Blank Reports'],
            [

            'logo' => null,
            'is_active' => true,
            'description' => 'Create reports that are created from scratch using Smart report maker wizard',
            'parent_id' => 1,

      ],
        );


        Capsule::table($this->table)->updateOrInsert(
            ['name' => 'Template Reports'],
            [
            'logo' => '',
            'is_active' => false,
            'description' => 'This category includes reports generated from templates, such as invoices, sales reports, etc. These reports are pre-designed and structured for specific purposes.',
            'parent_id' => 1,
      ],
        );


        Capsule::table($this->table)->updateOrInsert(
            ['name' => 'Charts'],
            [
            'logo' => '<i class="fa fa-bar-chart" aria-hidden="true"></i>',
            'is_active' => true,
            'description' => 'Generate dynamic charts that dynamically represent and visualize data from your selected data source.',
            'parent_id' => null,
      ],
        );


        Capsule::table($this->table)->updateOrInsert(
            ['name' => 'KPIs / Metrics'],
            [
            'logo' => '<i class="fa fa-balance-scale" aria-hidden="true"></i>',
            'is_active' => true,
            'description' => 'Specify and calculate specific Key Performance Indicators from your data source, allowing for careful monitoring and evaluation of crucial metrics.',
            'parent_id' => null,
      ],
        );


        Capsule::table($this->table)->updateOrInsert(
            ['name' => 'Dashboard'],
            [
            'logo' => '<i class="fa fa-tachometer" aria-hidden="true"></i>',
            'is_active' => false,
            'description' => 'Create a customizable dashboard where you can seamlessly integrate Reports, dynamic Charts, and calculated Metrics/KPIs as widgets. This provides a comprehensive and centralized view of essential information for effective decision-making.',
            'parent_id' => null,
      ],
        );

        Capsule::table($this->table)->updateOrInsert(
            ['name' => 'Pivot tables'],
            [
            'logo' => '<i class="fa fa-table" aria-hidden="true"></i>',
            'is_active' => false,
            'description' => 'Description',
            'parent_id' => null,
      ],
        );

        Capsule::table($this->table)->updateOrInsert(
            ['name' => 'Forms'],
            [
            'logo' => '<i class="fa fa-file-text" aria-hidden="true"></i>',
            'is_active' => false,
            'description' => 'Description',
            'parent_id' => null,
      ],
        );
    }
}
