<?php

namespace Webuccino\Install\seeder;

use Illuminate\Database\Capsule\Manager as Capsule;

class InstalledVersionsSeeder
{
    public $table;
    public $prefix;
    public function __construct()
    {
        $this->prefix = config_native('srm_config.installer.table_prefix');

        $this->table = $this->prefix . 'installed_versions';
    }

    public function run()
    {
        $version = config_native('srm_config.installer.version_to_install', "v9.1.2");
        Capsule::table($this->table)->updateOrInsert(
            ['version' => $version],
            [
                'is_current'                => true,
                'install_last_success_step' => "migrate",
                'is_install_complete'       => false,
                'install_url'               => $this->getInstalledVersion(),
                'installation_date'         => date('Y-m-d H:i:s'),
                'batch'                     => 1
            ]
        );
    }

    public function getInstalledVersion()
    {
        $php_self_path = explode("/install", base_url())[0];

        return $_SERVER["HTTP_HOST"] . $php_self_path;
    }
}
