<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateUsersTable
{
    public $table;
    public $prefix;
    public function __construct()
    {
        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'Users';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {

        $prefix = $this->prefix;

        Capsule::schema()->create($this->table, function (Blueprint $table) use ($prefix) {
            $table->id('user_ID');
            $table->string('Email', 50)->nullable()->unique();
            $table->string('user_name', 50)->nullable();
            $table->string('first_name', 50)->nullable();
            $table->string('last_name', 50)->nullable();
            $table->string('Phone', 50)->nullable();
            $table->string('Password', 255)->nullable();
            $table->foreignId('group_id')->nullable()->references('group_ID')->on($prefix . 'Group');
            $table->boolean('is_owner')->default(0);
            $table->boolean('is_admin')->nullable();
            $table->integer('Security_question_index')->nullable();
            $table->string('Security_answer', 50)->nullable();
            $table->integer('consecutive_login_failures')->default(0);
            $table->timestamp('last_lock_time')->nullable();
            $table->enum('status', ['Pended', 'Active', 'Blocked'])->nullable();
            $table->string('regestration_IP')->nullable();
            $table->string('last_change_password_IP')->nullable();
            $table->boolean('is_checked_guided_tour')->default(false);
            $table->integer('guided_tour_last_visited_step')->nullable();
            // $table->boolean('is_email_activated')->default(0);

            $table->timestamp('email_verified_at')->nullable();
            $table->foreignId('added_by')->nullable()->references('user_ID')->on($prefix . 'Users')->onUpdate('cascade')->onDelete('set null');
            $table->string('remember_token', 100)->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('edited_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }
}