<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateSettingsTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'Settings';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {

        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->id('ID');
            $table->string('settings_key', 50)->nullable();
            $table->text('settings_value')->nullable();
            $table->timestamp('created_at')->useCurrent();
        });
    }
}
