<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateScheduledTaskResourcesTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'scheduled_task_resources';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {
        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->foreignId('task_id')->references('id')->on($this->prefix . 'scheduled_tasks');
            $table->foreignId('resource_id')->references('id')->on($this->prefix . 'analytics_resources');
        });
    }
}
