<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Capsule\Manager as Capsule;
use Illuminate\Database\Schema\Blueprint;

class CreateResourceConfigurationTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'resource_configuration';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {
        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->id('ID');
            $table->foreignId('Resource_id')->nullable()->references('id')->on($this->prefix . 'analytics_resources')->onUpdate('cascade')->onDelete('set null');
            $table->text('Json_configurations');
            $table->string('chart_type')->nullable();
            $table->timestamp('created_at')->useCurrent();
        });
    }
}
