<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateModulesPermissionsTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'modules_premissions';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {
        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->foreignId('group_id')->nullable()->references('group_ID')->on($this->prefix . 'Group')->onUpdate('cascade')->onDelete('set null');
            $table->foreignId('module_id')->nullable()->references('id')->on($this->prefix . 'modules')->onUpdate('cascade')->onDelete('set null');
            $table->boolean('can_add_new');
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
        });
    }
}
