<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateMailTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'mail';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {
        $prefix = config_native('srm_config.installer.table_prefix');
        $table  = $prefix . 'mail';

        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->id('id');
            $table->string('smtp', 255)->nullable();
            $table->string('port', 50)->nullable();
            $table->string('username', 255)->nullable();
            $table->text('Password')->nullable();
            $table->string('encryption', 50)->default("tls");
            $table->string('auth_mode', 50)->nullable();
            $table->boolean('is_default', 50)->nullable();
            $table->timestamp('created_at')->useCurrent();
        });
    }
}
