<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Capsule\Manager as Capsule;

class CreateHomeDashboardTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'home_dashboard';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {
        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->id('id');
            $table->foreignId('user_id')->nullable()->references('user_ID')->on($this->prefix . 'Users')->onUpdate('cascade')->onDelete('set null');
            $table->foreignId('resource_id')->nullable()->references('id')->on($this->prefix . 'analytics_resources')->onUpdate('cascade')->onDelete('set null');
            $table->string('widget_title', 255)->nullable();
            $table->text('report_lists')->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }
}
