<?php

namespace webuccino\install\migrations;

use Illuminate\Database\Capsule\Manager as Capsule;
use Illuminate\Database\Schema\Blueprint;

class CreateAnalyticsResourcesTable
{
    public $table;
    public $prefix;
    public function __construct()
    {

        $this->prefix = config_native('srm_config.installer.table_prefix', 'srm_');

        $this->table = $this->prefix . 'analytics_resources';
    }

    public function getTableName()
    {
        return $this->table;
    }

    public function run()
    {
        Capsule::schema()->create($this->table, function (Blueprint $table) {
            $table->id('id');
            $table->string('name', 255)->unique();
            $table->string('url', 255);
            $table->enum('access_control_type', ['Public', 'Private']);
            $table->foreignId('module_id')->nullable()->references('id')->on($this->prefix . 'modules')->onUpdate('cascade')->onDelete('set null');
            $table->foreignId('category_id')->nullable()->references('id')->on($this->prefix . 'categories')->onUpdate('cascade')->onDelete('set null');
            $table->foreignId('resource_creator')->nullable()->references('user_ID')->on($this->prefix . 'Users')->onUpdate('cascade')->onDelete('set null');
            //$table->foreignId('data_connection_id')->nullable()->references('id')->on($this->prefix . 'dataconnections')->onUpdate('cascade')->onDelete('set null');
            $table->foreignId('data_connection_id')->nullable();
            $table->enum('widget_size', [
                1, // full-size
                2, // 1/2 size
                3  // 1/4 size
            ])->nullable();
            $table->enum("metric_color", [
                "white",
                "blue",
                "orange",
                "red",
                "purple",
                "green"
            ])->nullable();
            $table->string("info_box_icon", 255)->nullable();
            $table->timestamp('created_at')->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->timestamp('deleted_at')->nullable();
        });
    }
}
