<?php

use Webuccino\Install\Core\Session;
use Webuccino\Install\Core\ValidationException;

const BASE_PATH = __DIR__ . '/';

session_start();
define('ACCESS', 1);

require BASE_PATH . '../vendor/autoload.php';
require BASE_PATH . 'Core/functions.php';
require BASE_PATH . 'bootstrap.php';



if (config_native('srm_config.installer.debug_mode')) {
    error_reporting(E_ALL);
    ini_set('display_errors', 'On');
} else {
    error_reporting(0);
    ini_set('display_errors', 'Off');
}

$router = new Webuccino\Install\Core\Router();
require BASE_PATH . 'routes.php';

$uri = parse_url($_SERVER['REQUEST_URI'])['path'];

$uri = explode("/srm_install", $uri)[1];

$method = $_POST['_method'] ?? $_SERVER['REQUEST_METHOD'];
try {
    $router->route_native($uri, $method);
} catch (ValidationException $exception) {
    Session::flash('errors', $exception->errors);
    Session::flash('old', $exception->old);

    return redirect_native($router->previousUrl());
}

Session::unflash();
