<?php

use Webuccino\Install\Core\App;
use Webuccino\Install\Core\Session;
use Webuccino\Install\Core\Database;
use Webuccino\Install\Http\Forms\EmailForm;

// dd($_POST);

$db = App::resolve(Database::class);

if (isset($_POST['allow_smtp_later_form']) && $_POST['allow_smtp_later_form'] == 1) {
    Session::put('allow-smtp-later', true);
} elseif (isset($_POST['allow_smtp_later_form']) && $_POST['allow_smtp_later_form'] == 0) {
    Session::put('allow_smtp_later_form', false);
}

$form = EmailForm::validate($attributes = [
    'email'          => $_POST['email'],
    'name'           => $_POST['name'],
    'mail-signature' => $_POST['mail-signature'],
    'timezone'       => $_POST['timezone']
    // 'confirm-cronjob' => $_POST['confirm-cronjob'],
]);

$db->updateOrInsert(
    'Settings',
    ['settings_key' => 'timezone'],
    ['settings_value' => $attributes['timezone']]
);

$db->updateOrInsert(
    'Settings',
    ['settings_key' => 'fromEmail'],
    ['settings_value' => $attributes['email']]
);

$db->updateOrInsert(
    'Settings',
    ['settings_key' => 'fromName'],
    ['settings_value' => $attributes['name']]
);

$db->updateOrInsert(
    'Settings',
    ['settings_key' => 'mail_signature'],
    ['settings_value' => $attributes['mail-signature']]
);

// insert installation method (docker, composer, hosted_version)
$db->updateOrInsert(
    'Settings',
    ['settings_key' => 'installation_method'],
    ['settings_value' => config_native('srm_config.installer.installation_method', 'composer')]
);

finish_installer();

Session::put("finish-on-settings", true);

redirect_native(route_native('/finishInstallation'));