<?php

set_time_limit(1000);

use Webuccino\Install\Core\Seeder;
use Webuccino\Install\Core\Session;
use Webuccino\Install\Core\Migration;

try {

    (new Migration())->runMigrations();
    (new Seeder())->runSeeders();
    Session::put('database-imported', true);

    echo json_encode([
        "msg" => "DB imported successfully"
    ]);
} catch (\Exception $e) {

    Session::put('database-imported', false);

    echo json_encode([
        "msg" => $e->getMessage()
    ]);
}
