<?php

namespace Webuccino\Install\Core;

class Seeder
{
    public $seeders;

    public function __construct()
    {
        $this->seeders = [
            'Webuccino\Install\seeder\InstalledVersionsSeeder',
            'Webuccino\Install\seeder\ModulesSeeder',
            'Webuccino\Install\seeder\CategoriesSeeder',
            'Webuccino\Install\seeder\OrganizationSeeder',
            'Webuccino\Install\seeder\SettingsSeeder'
        ];

        if (!is_docker() ||
            (!is_null(getenv('ADD_TESTING_DATA')) && getenv('ADD_TESTING_DATA') == 'true')
        ) {
            $this->seeders[] = 'Webuccino\Install\seeder\NorthWindSeeder';
        }

    }

    public function runSeeders()
    {

        foreach ($this->seeders as $seeder) {
            (new $seeder())->run();

        }

    }

}