<?php

namespace Webuccino\Install\Core\Middleware;

class NonInstalled
{
    public function handle()
    {

        if (check_installed()) {

            if (urlIs('/importDatabase')) {
                $prefix = config_native("srm_config.installer.table_prefix");

                echo json_encode([
                    "msg" => "The installation has already been completed in this database, so you can go to the login page and begin using it. If you'd like to reinstall, please delete all tables in the database that start with \"$prefix\". Otherwise, you will be redirected to the login page to start using Smart Report Maker."
                ]);
                exit;
            }

            return redirect_native(route_native('/finishInstallation'));
            exit;
        }

    }

}