<?php

namespace Webuccino\Install\Core;

use Illuminate\Database\Capsule\Manager as Capsule;

use PDO;

class Database
{
    public $connection;
    public $statement;
    public $capsule;
    public function __construct($driver, $host, $db_name, $db_user, $db_password, $db_port)
    {
        $this->initiateConnection($driver, $host, $db_name, $db_user, $db_password, $db_port);
    }

    public function initiateConnection($driver, $host, $db_name, $db_user, $db_password, $db_port = "3306")
    {
        $this->capsule = new Capsule;

        $this->capsule->addConnection([
            "driver" => $driver,
            "host" => "$host:$db_port",
            "database" => $db_name,
            "username" => $db_user,
            "password" => $db_password,
        ]);

        $this->capsule->setAsGlobal();
        $this->capsule->bootEloquent();
    }


    public function checkConnection()
    {
        try {
            $this->capsule->getConnection()->getPdo();
            return $this->capsule->getConnection()->getDatabaseName();
        } catch (\Exception $e) {
            return false;
        }
    }

    public function getConnectionError()
    {
        try {
            $this->capsule->getConnection()->getPdo();
            return $this->capsule->getConnection()->getDatabaseName();
        } catch (\Exception $e) {
            return $e->getMessage();
        }
    }

    public function initiateConnectionFromconfig_native()
    {
        $config = config_native('srm_db_config');
        $this->initiateConnection(
            $config["driver"],
            $config["host"],
            $config["database"],
            $config["username"],
            $config["password"],
            $config["port"]
        );
    }

    public function create($table, $data)
    {
        $prefix = config_native('srm_config.installer.table_prefix');

        $this->capsule->table($prefix . $table)->insert($data);
    }

    public function checkExist($table, $condition)
    {
        $prefix = config_native('srm_config.installer.table_prefix');

        return $this->capsule->table($prefix . $table)->where($condition)->exists();
    }

    public function update($table, $condition, $updated_values)
    {
        $prefix = config_native('srm_config.installer.table_prefix');

        return $this->capsule->table($prefix . $table)->where($condition)->update($updated_values);
    }

    public function updateOrInsert($table, $match, $update)
    {
        $prefix = config_native('srm_config.installer.table_prefix');

        return $this->capsule->table($prefix . $table)->updateOrInsert($match, $update);
    }

    public function first($table, $condition)
    {
        $prefix = config_native('srm_config.installer.table_prefix');

        return $this->capsule->table($prefix . $table)->where($condition)->first();
    }

    public function hasTable($table)
    {
        $prefix = config_native('srm_config.installer.table_prefix');

        return $this->capsule::schema()->hasTable($prefix . $table);
    }

    public function countAllRecords($table)
    {
        $prefix = config_native('srm_config.installer.table_prefix');

        return $this->capsule->table($prefix . $table)->count();
    }
}