<?php
define("DIRECTACESS", 1);
define("TestMode", 1);
require_once "../SRM/Reports9/shared/helpers/Model/DatabaseHandler.php";
require_once "../SRM/Reports9/shared/helpers/session.php";
require_once "config.php";
require_once "constants.php";
require_once "functions.php";
require_once "db/autoload.php";
require_once "security/autoload.php";
require_once "dashboard/autoload.php";


//connection to the Dashboard Db
$dashboard_connection = new DatabaseHandler(DEFAULT_HOST, DEFAULT_DBUSER, DEFAULT_DBPASS, DEFAULT_DBNAME);
$srm_dashboard = new srm_dashboard($dashboard_connection);
$access_control = new Fake_Access_Control($_SESSION, $srm_dashboard);

?>
<html>
    <head>
        <script src="https://cdn.rawgit.com/google/code-prettify/master/loader/run_prettify.js"></script>

    </head>
    <body>
        <?php
        try {
            /*
             * ===============================================================================
             *               Security methods to ptotect reports and wizard 
             * ===============================================================================
             */
      $srm_dashboard->load_report_configurations(57);
      var_dump($_SESSION[Session_report_Settings_key]);
      exit();
            display_title("security methods");
            display_note("Groups which can access wizard");
            $wizard_permissions = $srm_dashboard->get_wizard_permissions();
            display_var($wizard_permissions);
            display_note("Display access level and permission of report 1, private can only accessed by group 1");
            $access_level = $srm_dashboard->get_report_access_type(1);
            display_var($access_level);
            $report_group_permissions = $srm_dashboard->get_private_report_permissions(1);
            display_var($report_group_permissions);
            /*
             * ===============================================================================
             *               Connection step in wizard
             * ===============================================================================
             */

            display_title("Connection step methods");
            display_note("Display all connections");
            $all_connections = $srm_dashboard->get_all_connection_names();
            display_var($all_connections);
            display_note("Display DEFAULT CONNECTION");
            $default_connection = $srm_dashboard->get_default_connection_details();
            display_var($default_connection);
            display_note("diplay a saved connection");
            $connection = $srm_dashboard->get_connection_details("northwind_connection");
            display_var($connection);
            display_note("display a non existed connection");
            $not_found_connection = $srm_dashboard->get_connection_details("not_found");
            display_var($not_found_connection);
            /*
             * ===============================================================================
             *               Groups and Categories steps in wizard
             * ===============================================================================
             */

            display_title("Groups and Categories step");
            display_note("diplay all categories names and IDs");
            $all_categories = $srm_dashboard->get_all_categories_names();
            display_var($all_categories);
            display_note("diplay all Groups names and IDs");
            $all_groups = $srm_dashboard->get_all_groups_names();
            display_note("Display all groups names and Ids");
            display_var($all_groups);
            /*
             * ===============================================================================
             *              Creating a new report in Engine
             * ===============================================================================
             */
            $report_name = " report " . rand();
            if (!$srm_dashboard->is_report_existed_by_name($report_name)) {
                display_title("Saving a new report: $report_name");
                display_note("adding a report in respurces table");
                $new_rep_id = $srm_dashboard->save_new_blank_report($report_name, 1, "northwind_connection", 1, private_report);
                echo "<br/>Inserted_report_id:";
                display_var($new_rep_id);
                display_note("insert permissions of the new report");
                $ids = $srm_dashboard->save_private_report_permissions($new_rep_id, array(1, 2));
                display_var($ids);
                display_note("save report configurations");
                $report_configuration = array();
                $configuration_session_object = json_encode($report_configuration);
                $result = $srm_dashboard->save_resource_configurations($new_rep_id, $configuration_session_object);
                echo "results of saving configurations";
                display_var($result);
            } else {
                display_error("Report already existed");
            }


            if ($srm_dashboard->is_report_existed_by_name($report_name)) {
                display_title("Editing another report $report_name");
                $edited_rep_id = $srm_dashboard->edit_blank_report($report_name,3, "northwind_connection", 2, private_report);
                echo "<br/>$edited_rep_id:";
                display_var($edited_rep_id);
                display_note("editing report permissions");
                $ids = $srm_dashboard->change_private_report_permissions($edited_rep_id, array(2));
                display_var($ids);
                display_note("editing report configurations");
                $edit_report_configuration = array();
                $configuration_session_object = json_encode($edit_report_configuration);
                $result = $srm_dashboard->edit_resource_configurations($edited_rep_id, $configuration_session_object);
                display_var($result);
                $srm_dashboard->load_report_configurations($edited_rep_id);
                display_var($_SESSION);
                $srm_dashboard->unload_report_configurations($edited_rep_id);
                display_var($_SESSION);
            }
            $srm_dashboard->delete_report_with_permissions($new_rep_id);
        } catch (Exception $ex) {
            display_error($ex->getMessage());
        }


        /*         * ***** formatting quick functions *********** */

        function display_note($note) {

            echo "<h5><font color='#00008B'>$note</font></h5>";
            echo "================================================================";
        }

        function display_var($var) {
            echo "<font color='green'><h6>------------------------------------------ Start displaying a RETURN value of type: " . gettype($var) . "----------------------------------</h6>";
            if (empty($var)) {
                echo "<br/>return is empty " . gettype($var);
            }
            if (is_array($var)) {
                foreach ($var as $k => $v) {
                    if (!is_array($v))
                        echo "  <h5>#$k:$v</h5>";
                    else
                        display_var($v);
                }
            } else {

                echo "  " . $var;
            }
            echo "<h6>-------------------------------------------- End displaying a return value of type " . gettype($var) . "-------------------------</h6></font>";
        }

        function display_title($title) {
            echo "*****************************************************************";
            echo "<h2><font color='#00008B'>$title</font></h2>";
            echo "******************************************************************";
        }

        function display_error($error) {
            echo "<font color='red'>++++++++++++++++++++++++++++++++++++++++++++++++++++++++++";
            echo "<h4>Error: $error</h4>";
            echo "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++</font>";
        }
        ?> 
    </body>
</html>