<?php

/**
 * Smart Reporting Package
 * Version 9.0.0
 * Author : Webuccino
 * All copyrights are preserved to Webuccino
 * URL : https://mysqlreports.com/
 */
class Fake_Access_Control extends access_control_abstract {

    

    public function __construct($user_session_data, $dashboard) {
        if (is_array($user_session_data) && isset($user_session_data[srm_access_session_key]) && is_array($user_session_data[srm_access_session_key])) {
            $this->user_session = $user_session_data[srm_access_session_key];
        } else {
            $this->user_session = array();
        }
        $this->dashboard = $dashboard;
    }

    
       /**
     * get all groups that should has access to this resource if any
     */
    protected function get_resource_access_groups($resource) {
        if ($resource == 1 || $resource == 2) {
            return array(1);
        } elseif ($resource == 3 || $resource == 4) {
            return array(2);
        }
    }

    /**
     * get all groups that can access wizard if any
     */
    protected function get_wizard_access_groups() {
        return array(1);
    }

    /**
     * get resource type "public","private" or "admin_only".
     */
    protected function get_resource_type($resource) {
        if ($resource === 5)
            return public_report;
        else
            return private_report;
    }

    /**
     * check the user current group can access this resource
     */
    protected function check_group_access_wizard() {
        return true;
    }

    /**
     * check the user current group can access this resource
     */
    protected function check_group_access_resource($resource) {
        if (strtolower($this->user_saved_role) == "admin") {
            return true;
        } else {
            $allowed_groups = $this->get_resource_access_groups($resource);
            if (is_array($allowed_groups) && in_array($this->user_saved_group, $allowed_groups)) {
                return true;
            } else {
                return false;
            }
        }
    }
}
