<?php

namespace Tests\Feature;

use App\Builders\ChartBuilder;
use Tests\TestCase;
use App\Models\Resource;
use App\Models\ResourceConfiguration;
use Illuminate\Foundation\Testing\RefreshDatabase;

class ChartBuilderTest extends TestCase
{
    use RefreshDatabase;

    public $chart;
    protected function setUp(): void
    {
        $this->createApplication();
    }

    /**
     * @test
     */
    public function chartBuilderBuildsCorrectlyWithTextualDataInSameTable()
    {
        $chart = Resource::where("name", "test 3")->first();

        if(isset($chart)) {
            ResourceConfiguration::where('Resource_id', $chart->id)->delete();
            $chart->forceDelete();
        }

        $this->chart = Resource::create([
            'name' => "test 3",
            'url' => "test 3",
            'access_control_type' => "Private",
            'data_connection_id' => 3,
            'module_id' => 4,
            'category_id' => 2,
            'widget_size' => 1,
            'resource_creator' => 5
        ]);
        $configurations = [
            'name' => "test 3",
            'title' => "test 3",
            'category' => 2,
            'connection' => 3,
            'security_type' => "Private",
            'groups' =>  null,
            'chart_type' => "bar-chart",
            'chart_link' => true,
            'x_table' => "Customers",
            'x_axis_column' => "City",
            'date_range' => "",
            'date_time_scale' =>  "",
            'data_filter_columns' => ["Berlin","México D.F.","London"],
            'y_table' => "Customers",
            'y_axis_column' => "CustomerName",
            'label' => "",
            'function' => "count",
            'drill_down' => false,
            'drill_down_columns' => ""
        ];

        ResourceConfiguration::create([
            'Resource_id' => $this->chart->id,
            'Json_configurations' => $configurations,
            'chart_type' => "bar-chart"
        ]);


        (new ChartBuilder($this->chart))->build();


        $this->assertArrayHasKey("x_axis", $this->chart->data);

        $this->assertArrayHasKey("y_axis", $this->chart->data);

        $x_axis = ["Berlin","México D.F.","London"];

        $y_axis = [1, 5, 6];

        $this->assertEquals($x_axis, $this->chart->data["x_axis"]);
        $this->assertEquals($y_axis, $this->chart->data["y_axis"]);
    }
    /**
     * @test
     */
    public function chartBuilderBuildsCorrectlyWithDateTimeInSameTable()
    {
        $chart = Resource::where("name", "test 4")->first();

        if(isset($chart)) {
            ResourceConfiguration::where('Resource_id', $chart->id)->delete();
            $chart->forceDelete();
        }

        $this->chart = Resource::create([
            'name' => "test 4",
            'url' => "test 4",
            'access_control_type' => "Private",
            'data_connection_id' => 3,
            'module_id' => 4,
            'category_id' => 2,
            'widget_size' => 1,
            'resource_creator' => 5

        ]);

        $configurations = [
            'name' => "test 4",
            'title' => "test 4",
            'category' => 2,
            'connection' => 3,
            'security_type' => "Private",
            'groups' =>  null,
            'chart_type' => "timeseries",
            'chart_link' => true,
            'x_table' => "Employees",
            'x_axis_column' => "BirthDate",
            'date_range' => "last_5_years",
            'date_time_scale' =>  "years",
            'data_filter_columns' => null,
            'y_table' => "Employees",
            'y_axis_column' => "FirstName",
            'label' => "",
            'function' => "count",
            'drill_down' => false,
            'drill_down_columns' => ""
        ];

        ResourceConfiguration::create([
            'Resource_id' => $this->chart->id,
            'Json_configurations' => $configurations,
            'chart_type' => "timeseries"
        ]);

        (new ChartBuilder($this->chart))->build();

        $this->assertArrayHasKey("x_axis", $this->chart->data);

        $this->assertArrayHasKey("y_axis", $this->chart->data);

        $x_axis = [2022, 2023, 2021, 2019];

        $y_axis = [2, 1, 1, 2];

        $this->assertEquals($x_axis, $this->chart->data["x_axis"]);

        $this->assertEquals($y_axis, $this->chart->data["y_axis"]);
    }


    /**
     * @test
     */
    public function chartBuilderBuildsCorrectlyWithTextualDataInDifferentTables()
    {
        $chart = Resource::where("name", "test")->first();

        if(isset($chart)) {
            ResourceConfiguration::where('Resource_id', $chart->id)->delete();
            $chart->forceDelete();
        }

        $this->chart = Resource::create([
            'name' => "test",
            'url' => "test",
            'access_control_type' => "Private",
            'data_connection_id' => 1,
            'module_id' => 4,
            'category_id' => 2,
            'widget_size' => 1,
            'resource_creator' => 5
        ]);

        $configurations = [
            'name' => "test",
            'title' => "test",
            'category' => 2,
            'connection' => 1,
            'security_type' => "Private",
            'groups' =>  null,
            'chart_type' => "bar-chart",
            'chart_link' => true,
            'x_table' => "srm_Users",
            'x_axis_column' => "user_name",
            'date_range' => "",
            'date_time_scale' =>  "",
            'data_filter_columns' => ["Ahmed","A.karim.sales","A.karim.support"],
            'y_table' => "srm_Group",
            'y_axis_column' => "name",
            'label' => "",
            'function' => "count",
            'drill_down' => false,
            'drill_down_columns' => ""

        ];

        ResourceConfiguration::create([
            'Resource_id' => $this->chart->id,
            'Json_configurations' => $configurations,
            'chart_type' => "bar-chart"
        ]);


        (new ChartBuilder($this->chart))->build();

        $this->assertArrayHasKey("x_axis", $this->chart->data);


        $this->assertArrayHasKey("y_axis", $this->chart->data);


        $x_axis = ["Ahmed","A.karim.sales","A.karim.support"];

        $y_axis = [1,1,1];

        $this->assertEquals($x_axis, $this->chart->data["x_axis"]);
        $this->assertEquals($y_axis, $this->chart->data["y_axis"]);
    }

    /**
     * @test
     */

    public function chartBuilderBuildsCorrectlyWithDateTimeInDifferentTables()
    {
        $chart = Resource::where("name", "test 2")->first();

        if(isset($chart)) {
            ResourceConfiguration::where('Resource_id', $chart->id)->delete();
            $chart->forceDelete();
        }

        $this->chart = Resource::create([
            'name' => "test 2",
            'url' => "test 2",
            'access_control_type' => "Private",
            'data_connection_id' => 1,
            'module_id' => 4,
            'category_id' => 2,
            'widget_size' => 1,
            'resource_creator' => 5

        ]);

        $configurations = [
            'name' => "test 2",
            'title' => "test 2",
            'category' => 2,
            'connection' => 1,
            'security_type' => "Private",
            'groups' =>  null,
            'chart_type' => "timeseries",
            'chart_link' => true,
            'x_table' => "srm_Users",
            'x_axis_column' => "created_at",
            'date_range' => "last_3_months",
            'date_time_scale' =>  "months",
            'data_filter_columns' => null,
            'y_table' => "srm_Group",
            'y_axis_column' => "name",
            'label' => "",
            'function' => "count",
            'drill_down' => false,
            'drill_down_columns' => ""
        ];

        ResourceConfiguration::create([
            'Resource_id' => $this->chart->id,
            'Json_configurations' => $configurations,
            'chart_type' => "timeseries"
        ]);

        (new ChartBuilder($this->chart))->build();

        $this->assertArrayHasKey("x_axis", $this->chart->data);

        $this->assertArrayHasKey("y_axis", $this->chart->data);

        $x_axis = [2];

        $y_axis = [3];

        $this->assertEquals($x_axis, $this->chart->data["x_axis"]);

        $this->assertEquals($y_axis, $this->chart->data["y_axis"]);
    }


    /**
     * @test
     */
    public function chartBuilderBuildsCorrectlyWithTimeSeriesDataAndCountFunction()
    {
        $chart = Resource::where("name", "test 6")->first();

        if(isset($chart)) {
            ResourceConfiguration::where('Resource_id', $chart->id)->delete();
            $chart->forceDelete();
        }

        $this->chart = Resource::create([
            'name' => "test 6",
            'url' => "test 6",
            'access_control_type' => "Private",
            'data_connection_id' => 3,
            'module_id' => 4,
            'category_id' => 2,
            'widget_size' => 1,
            'resource_creator' => 5
        ]);

        $configurations = [
            'name' => "test 6",
            'title' => "test 6",
            'category' => 2,
            'connection' => 3,
            'security_type' => "Private",
            'groups' =>  null,
            'chart_type' => "timeseries",
            'chart_link' => true,
            'x_table' => "Employees",
            'x_axis_column' => "BirthDate",
            'date_range' => "last_5_years",
            'date_time_scale' =>  "years",
            'data_filter_columns' => null,
            'y_table' => "Employees",
            'y_axis_column' => "FirstName",
            'label' => "",
            'function' => "count",
            'drill_down' => false,
            'drill_down_columns' => ""
        ];

        ResourceConfiguration::create([
            'Resource_id' => $this->chart->id,
            'Json_configurations' => $configurations,
            'chart_type' => "timeseries"
        ]);


        (new ChartBuilder($this->chart))->build();

        // dd($this->chart);
        $this->assertArrayHasKey("x_axis", $this->chart->data);

        $this->assertArrayHasKey("y_axis", $this->chart->data);

        $x_axis = [2022, 2023, 2021, 2019];

        $y_axis = [2, 1, 1, 2];

        $this->assertEquals($x_axis, $this->chart->data["x_axis"]);

        $this->assertEquals($y_axis, $this->chart->data["y_axis"]);
    }



    /**
     * @test
     */
    public function chartBuilderBuildsCorrectlyWithNumericDataAndAVGFunction()
    {
        $chart = Resource::where("name", "test 5")->first();

        if(isset($chart)) {
            ResourceConfiguration::where('Resource_id', $chart->id)->delete();
            $chart->forceDelete();
        }

        $this->chart = Resource::create([
            'name' => "test 5",
            'url' => "test 5",
            'access_control_type' => "Private",
            'data_connection_id' => 3,
            'module_id' => 4,
            'category_id' => 2,
            'widget_size' => 1,
            'resource_creator' => 5
        ]);

        $configurations = [
            'name' => "test 5",
            'title' => "test 5",
            'category' => 2,
            'connection' => 3,
            'security_type' => "Private",
            'groups' =>  null,
            'chart_type' => "bar-chart",
            'chart_link' => true,
            'x_table' => "Employees",
            'x_axis_column' => "city",
            'date_range' => "",
            'date_time_scale' =>  "",
            'data_filter_columns' => ["Cairo","Alex","London"],
            'y_table' => "Employees",
            'y_axis_column' => "salary",
            'label' => "",
            'function' => "average",
            'drill_down' => false,
            'drill_down_columns' => ""
        ];

        ResourceConfiguration::create([
            'Resource_id' => $this->chart->id,
            'Json_configurations' => $configurations,
            'chart_type' => "bar-chart"
        ]);


        (new ChartBuilder($this->chart))->build();


        $this->assertArrayHasKey("x_axis", $this->chart->data);

        $this->assertArrayHasKey("y_axis", $this->chart->data);

        $x_axis = ["Cairo","Alex","London"];

        $y_axis = [4000, 3400, 4050];

        $this->assertEquals($x_axis, $this->chart->data["x_axis"]);

        $this->assertEquals($y_axis, $this->chart->data["y_axis"]);
    }


    /**
     * @test
     */
    public function chartBuilderBuildsCorrectlyWithNumericDataAndSumFunction()
    {
        $chart = Resource::where("name", "test 10")->first();

        if(isset($chart)) {
            ResourceConfiguration::where('Resource_id', $chart->id)->delete();
            $chart->forceDelete();
        }

        $this->chart = Resource::create([
            'name' => "test 10",
            'url' => "test 10",
            'access_control_type' => "Private",
            'data_connection_id' => 3,
            'module_id' => 4,
            'category_id' => 2,
            'widget_size' => 1,
            'resource_creator' => 5
        ]);

        $configurations = [
            'name' => "test 10",
            'title' => "test 10",
            'category' => 2,
            'connection' => 3,
            'security_type' => "Private",
            'groups' =>  null,
            'chart_type' => "bar-chart",
            'chart_link' => true,
            'x_table' => "Employees",
            'x_axis_column' => "city",
            'date_range' => "",
            'date_time_scale' =>  "",
            'data_filter_columns' => ["Cairo","Alex","London"],
            'y_table' => "Employees",
            'y_axis_column' => "salary",
            'label' => "",
            'function' => "sum",
            'drill_down' => false,
            'drill_down_columns' => ""
        ];

        ResourceConfiguration::create([
            'Resource_id' => $this->chart->id,
            'Json_configurations' => $configurations,
            'chart_type' => "bar-chart"
        ]);


        (new ChartBuilder($this->chart))->build();


        $this->assertArrayHasKey("x_axis", $this->chart->data);

        $this->assertArrayHasKey("y_axis", $this->chart->data);
        $x_axis = ["Cairo","Alex","London"];

        $y_axis = ["12000", "10200", "16200"];

        $this->assertEquals($x_axis, $this->chart->data["x_axis"]);

        $this->assertEquals($y_axis, $this->chart->data["y_axis"]);
    }

    /**
     * @test
     */
    public function chartBuilderBuildsCorrectlyWithNumericDataAndMaxFunction()
    {
        $chart = Resource::where("name", "test 9")->first();

        if(isset($chart)) {
            ResourceConfiguration::where('Resource_id', $chart->id)->delete();
            $chart->forceDelete();
        }

        $this->chart = Resource::create([
            'name' => "test 9",
            'url' => "test 9",
            'access_control_type' => "Private",
            'data_connection_id' => 3,
            'module_id' => 4,
            'category_id' => 2,
            'widget_size' => 1,
            'resource_creator' => 5
        ]);

        $configurations = [
            'name' => "test 9",
            'title' => "test 9",
            'category' => 2,
            'connection' => 3,
            'security_type' => "Private",
            'groups' =>  null,
            'chart_type' => "bar-chart",
            'chart_link' => true,
            'x_table' => "Employees",
            'x_axis_column' => "city",
            'date_range' => "",
            'date_time_scale' =>  "",
            'data_filter_columns' => ["Cairo","Alex","London"],
            'y_table' => "Employees",
            'y_axis_column' => "salary",
            'label' => "",
            'function' => "max",
            'drill_down' => false,
            'drill_down_columns' => ""
        ];

        ResourceConfiguration::create([
            'Resource_id' => $this->chart->id,
            'Json_configurations' => $configurations,
            'chart_type' => "bar-chart"
        ]);


        (new ChartBuilder($this->chart))->build();


        $this->assertArrayHasKey("x_axis", $this->chart->data);

        $this->assertArrayHasKey("y_axis", $this->chart->data);
        $x_axis = ["Cairo","Alex","London"];

        $y_axis = ["6000", "7000", "6700"];

        $this->assertEquals($x_axis, $this->chart->data["x_axis"]);

        $this->assertEquals($y_axis, $this->chart->data["y_axis"]);
    }



    /**
     * @test
     */
    public function chartBuilderBuildsCorrectlyWithNumericDataAndStdFunction()
    {
        $chart = Resource::where("name", "test 8")->first();

        if(isset($chart)) {
            ResourceConfiguration::where('Resource_id', $chart->id)->delete();
            $chart->forceDelete();
        }

        $this->chart = Resource::create([
            'name' => "test 8",
            'url' => "test 8",
            'access_control_type' => "Private",
            'data_connection_id' => 3,
            'module_id' => 4,
            'category_id' => 2,
            'widget_size' => 1,
            'resource_creator' => 5
        ]);

        $configurations = [
            'name' => "test 8",
            'title' => "test 8",
            'category' => 2,
            'connection' => 3,
            'security_type' => "Private",
            'groups' =>  null,
            'chart_type' => "bar-chart",
            'chart_link' => true,
            'x_table' => "Employees",
            'x_axis_column' => "city",
            'date_range' => "",
            'date_time_scale' =>  "",
            'data_filter_columns' => ["Cairo","Alex","London"],
            'y_table' => "Employees",
            'y_axis_column' => "salary",
            'label' => "",
            'function' => "sample-standard-deviation",
            'drill_down' => false,
            'drill_down_columns' => ""
        ];

        ResourceConfiguration::create([
            'Resource_id' => $this->chart->id,
            'Json_configurations' => $configurations,
            'chart_type' => "bar-chart"
        ]);


        (new ChartBuilder($this->chart))->build();


        $this->assertArrayHasKey("x_axis", $this->chart->data);

        $this->assertArrayHasKey("y_axis", $this->chart->data);
        $x_axis = ["Cairo","Alex","London"];

        $y_axis = [2160.2468994692867, 2566.4502073226877, 1769.8870020427858];

        $this->assertEquals($x_axis, $this->chart->data["x_axis"]);

        $this->assertEquals($y_axis, $this->chart->data["y_axis"]);
    }


    /**
    * @test
    */
    public function chartBuilderBuildsCorrectlyWithNumericDataAndStdPopFunction()
    {
        $chart = Resource::where("name", "test 12")->first();

        if(isset($chart)) {
            ResourceConfiguration::where('Resource_id', $chart->id)->delete();
            $chart->forceDelete();
        }

        $this->chart = Resource::create([
            'name' => "test 12",
            'url' => "test 12",
            'access_control_type' => "Private",
            'data_connection_id' => 3,
            'module_id' => 4,
            'category_id' => 2,
            'widget_size' => 1,
            'resource_creator' => 5
        ]);

        $configurations = [
            'name' => "test 12",
            'title' => "test 12",
            'category' => 2,
            'connection' => 3,
            'security_type' => "Private",
            'groups' =>  null,
            'chart_type' => "bar-chart",
            'chart_link' => true,
            'x_table' => "Employees",
            'x_axis_column' => "city",
            'date_range' => "",
            'date_time_scale' =>  "",
            'data_filter_columns' => null,
            'y_table' => "Employees",
            'y_axis_column' => "salary",
            'label' => "",
            'function' => "population-standard-deviation",
            'drill_down' => false,
            'drill_down_columns' => ""
        ];

        ResourceConfiguration::create([
            'Resource_id' => $this->chart->id,
            'Json_configurations' => $configurations,
            'chart_type' => "bar-chart"
        ]);


        (new ChartBuilder($this->chart))->build();
        $this->assertArrayHasKey("x_axis", $this->chart->data);

        $this->assertArrayHasKey("y_axis", $this->chart->data);

        $x_axis = [];

        $y_axis = [];

        $this->assertEquals($x_axis, $this->chart->data["x_axis"]);

        $this->assertEquals($y_axis, $this->chart->data["y_axis"]);
    }

}
