<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title>Smart Report Maker</title>

    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback"
        crossorigin="anonymous" />

    <link rel="stylesheet" href="<?php echo e(get_asset('dist/css/all.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(get_asset('dist/css/adminlte.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(get_asset('dist/css/style.css')); ?>" />

    <link rel="stylesheet" href="<?php echo e(get_asset('dist/css/driver.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(get_asset('dist/css/tour.css')); ?>">


    <script src="<?php echo e(get_asset('dist/js/jquery.min.js')); ?>"></script>
    <script src="<?php echo e(get_asset('dist/js/dotlottie-player.mjs')); ?>" type="module">
    </script>

    <script src="<?php echo e(get_asset('dist/js/head.js')); ?>"></script>

    <?php echo $__env->yieldContent('styles'); ?>
    <?php echo $__env->yieldContent('head-scripts'); ?>
</head>

<body class="hold-transition sidebar-mini">
    <?php echo $__env->make('partials._quick-add-blue', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('partials._info', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div id="global-loader">
        <dotlottie-player class="loader-img" src="<?php echo e(get_asset('dist/images/loader.json')); ?>" background="transparent"
            speed="1" style="width: 150px; height: 150px;" loop autoplay></dotlottie-player>
        <div class="loader-text"></div>
    </div>

    <?php echo $__env->make('partials._demo-modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo $__env->make('partials._tour-confirmation',[
    'id' => 'tour-rewatch',
    'modal_title' =>'Rewatch The Guided Tour',
    'method'=> 'POST'
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <div class="wrapper">
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">
            <div class="d-flex justify-content-between mb-1">
                <ul class="navbar-nav">
                    <li class="nav-item">
                        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i
                                class="fas fa-bars"></i></a>
                    </li>
                    <li class="nav-item d-none d-sm-inline-block">
                        <a type="button" class="btn btn-secondary bg-white mx-2 border-0" data-toggle="tooltip"
                            data-placement="top" title="Home" href="<?php echo e(route('home')); ?>">
                            <i class="fa-solid fa-house"></i>
                        </a>
                    </li>
                </ul>
                <ul class="navbar-nav ml-auto">
                    <li class="nav-item dropdown">
                        <button class="bg-white mx-2 my-1 border-0" data-toggle="modal" data-target="#quick-add-modal">

                            
                            <svg fill="#000000" viewBox="0 0 24 24" width="20" height="20"
                                xmlns="http://www.w3.org/2000/svg" data-toggle="tooltip" data-placement="top"
                                title="Quick add">

                                <g data-name="Layer 2">

                                    <g data-name="plus-circle">

                                        <rect width="24" height="24" opacity="0" viewBox="0 0 24 24" />

                                        <path
                                            d="M12 2a10 10 0 1 0 10 10A10 10 0 0 0 12 2zm0 18a8 8 0 1 1 8-8 8 8 0 0 1-8 8z" />

                                        <path
                                            d="M15 11h-2V9a1 1 0 0 0-2 0v2H9a1 1 0 0 0 0 2h2v2a1 1 0 0 0 2 0v-2h2a1 1 0 0 0 0-2z" />

                                    </g>

                                </g>

                            </svg>

                            

                        </button>
                    </li>

                    <?php if(checkDemo()): ?>
                    <li class="nav-item">
                        <a type="button" class="btn btn-secondary bg-white mx-2 border-0" id="start-demo-tour"
			    data-toggle="tooltip" data-placement="top" title="Guided Tour" data-image="<?php echo e(get_asset('dist/images/srm-logo.jpg')); ?>">
                            <i class="fa-solid fa-repeat"></i>
                        </a>
                    </li>
                    <?php else: ?>
                    <li class="nav-item">
                        <a type="button" class="btn btn-secondary bg-white mx-2 border-0" id="start-tour"
                            data-toggle="tooltip" data-placement="top" title="Guided Tour" data-image="<?php echo e(get_asset('dist/images/srm-logo.jpg')); ?>" 
                            data-start="<?php echo e(route('tour.start')); ?>" data-step="<?php echo e(route('tour.step')); ?>"
                            data-stop="<?php echo e(route('tour.stop')); ?>">
                            <i class="fa-solid fa-repeat"></i>
                        </a>
                    </li>
                    <?php endif; ?>

                    <li class="nav-item dropdown">
                        <a type="button" class="btn btn-secondary bg-white mx-2 border-0" data-toggle="tooltip"
                            data-placement="top" title="Profile" href="<?php echo e(route('profile.index')); ?>">
                            <i class="fa-solid fa-user"></i>
                        </a>
                    </li>
                    <li class="nav-item dropdown">
                        <a type="button" class="btn btn-secondary bg-white mx-2 border-0" data-toggle="tooltip"
                            data-placement="top" title="help" target="_blank"
                            href="https://mysqlreports.com/smart-report-maker-docs/smart-report-maker-docs/">
                            <i class="fa-solid fa-question-circle"></i>
                        </a>
                    </li>


                    

                    <?php if(checkDemo()): ?>
                    <li class="nav-item">
                        <a type="button" target="_blank" href="<?php echo e(config('srm_config.dashboard.demo.Buy_link')); ?>"
                            class="btn btn-secondary bg-white mx-2 border-0" data-toggle="tooltip" data-placement="top"
                            title="Purchase">
                            <i class="fa-solid fa-cart-shopping"></i>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if(auth()->user()->isAdminOrOwner() && !checkDemo()): ?>
                    <li class="nav-item dropdown">
                        <button type="button" class="btn btn-secondary bg-white mx-2 border-0" data-placement="top"
                            title="info" data-toggle="modal" data-tooltip-toggle="tooltip" data-target="#info-modal">
                            <i class="fa-solid fa-info-circle"></i>
                        </button>
                    </li>
                    <?php endif; ?>

                    <li class="nav-item">
                        <a type="button" class="btn btn-secondary bg-white mx-2 border-0" data-toggle="tooltip"
                            data-placement="top" title="Logout" onclick="event.preventDefault();
                            document.getElementById('logout-form').submit();">
                            <i class="fa-solid fa-right-from-bracket"></i>
                        </a>
                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" style="display: none;">
                            <?php echo csrf_field(); ?>
                        </form>

                    </li>
                </ul>
            </div>
            <div class="d-flex justify-content-between">
                <div class="alert bootstrap-alert-danger flex-grow-1 ml-3" role="alert"
                    style="max-width: 80%; <?php echo e(empty(session('security_errors')) ? 'display: none' : ''); ?>">
                    <?php if(!empty(session('security_errors'))): ?>
                    <ul class="mb-0 text-left">
                        <?php if(isset(session('security_errors')['security_check_error'])): ?>
                        <li id="security-error-alert"><?php echo e(session('security_errors')['security_check_error']); ?> <a
                                class="text-decoration-none text-primary <?php echo e(isset(session('security_errors')['security_check_error']) ? '' : 'd-d-none'); ?>"
                                href="<?php echo e(route('securityCheck')); ?>">check
                                now</a></li>
                        <?php endif; ?>
                        <?php if(isset(session('security_errors')['install_check_error'])): ?>
                        <li><?php echo e(session('security_errors')['install_check_error']); ?></li>
                        <?php endif; ?>

                        <?php if(isset(session('security_errors')['install_script_check_error'])): ?>
                        <li><?php echo e(session('security_errors')['install_script_check_error']); ?></li>
                        <?php endif; ?>

                        <?php if(isset(session('security_errors')['user_security_question_check_error'])): ?>
                        <li><?php echo session('security_errors')['user_security_question_check_error']; ?></li>
                        <?php endif; ?>
                    </ul>

                    <?php endif; ?>
                </div>
                
            </div>
        </nav>
        <?php echo $__env->make('partials._aside', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php echo $__env->yieldContent('content'); ?>
    </div>
    <script type="text/javascript" src="<?php echo e(get_asset('dist/js/bootstrap.bundle.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(get_asset('dist/js/index.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(get_asset('dist/js/adminlte.min.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(get_asset('dist/js/dashboard.js')); ?>"></script>
    <script src="<?php echo e(get_asset('dist/js/driver.js')); ?>"></script>
    <script src="<?php echo e(get_asset('dist/js/tour/tour-guide.js')); ?>"></script>

    <?php if(checkDemo()): ?>

    <?php if(session('tour_guide_shown')): ?>
    <script src="<?php echo e(get_asset('dist/js/tour-demo-guide.js')); ?>"></script>
    <?php endif; ?>
    <script src="<?php echo e(get_asset('dist/js/start-demo-tour.js')); ?>"></script>
    <?php endif; ?>

    <?php if(!checkDemo() && !isCheckedGuidedTour()): ?>
    <script>
        <?php echo tourScript(); ?>

    </script>

    <?php endif; ?>

    <script>
        $(function() {
            $("#global-loader").fadeOut("slow");
        });
        window.addEventListener("beforeunload", function (event) {
            $("#global-loader").fadeIn();
        });
    </script>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>

</html>
<?php /**PATH /var/www/html/srm_phpv81_or_later/srm/dashboard/resources/views/layouts/app.blade.php ENDPATH**/ ?>